/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Feb 2010)
**=======================================================================*/

#ifndef  _SO_TEXT_MARGIN_ELEMENT_
#define  _SO_TEXT_MARGIN_ELEMENT_

#include <Inventor/elements/SoFloatElement.h>

/**
*  @VSGEXT Stores the current text margin.
*
* @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current text margin value. The margin value is a factor of current
*   font size.
*
*   @SEE_ALSO
*   SoTextProperty
*/
SoEXTENDER_Documented class INVENTOR_API SoTextMarginElement : public SoFloatElement
{

  SO_ELEMENT_HEADER(SoTextMarginElement);

 public:

   /**
   *  Sets the current horizontal text margin in the state.
   */
   static void set(SoState *state, float margin);

   /**
   *  Sets the current horizontal text margin in the state.
   */
  static void set(SoState* state, SoNode*, float margin) { set(state, margin); }

  /**
  *  Returns current margin from the state.
  */
  static float get(SoState* state) { return SoFloatElement::get(getClassTypeId(), getClassStackIndex(), state); }

  /**
  *  Returns the default margin.
  */
  static float getDefault();

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:

  // Initializes the SoTextMarginElement class
  static void initClass();
  static void exitClass();

 protected:
  virtual ~SoTextMarginElement();

 private:
  static float s_defaultMarginFactor;
  static bool s_isSet;
};

#endif // _SO_TEXT_MARGIN_ELEMENT_

/**/


