/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Aug 2009)
**=======================================================================*/

#ifndef SO_TEXT_EFFECTS_COLOR_ELEMENT
#define SO_TEXT_EFFECTS_COLOR_ELEMENT

#include <Inventor/elements/SoReplacedElement.h>
#include <Inventor/fields/SoMFColorRGBA.h>
#include <Inventor/SbColorRGBA.h>

/**
 * @VSGEXT Stores the current textured text quality range.
 *
 * @ingroup elements
 * 
 *   @DESCRIPTION
 *   This element stores the current textured text quality range value.
 *
 *   @SEE_ALSO
 *   SoTextProperty
 */

SoEXTENDER_Documented class INVENTOR_API SoTextStyleColorsElement : public SoReplacedElement
{
  SO_ELEMENT_HEADER(SoTextStyleColorsElement);

 public:

  /**
   *  Sets the current range in the state.
   */
  static void set(SoState* state, SoNode *node, const SbColorRGBA* colors);

  /**
   *  Gets the current range in the state.
   */
  static const SbColorRGBA* get(SoState* state);

  /**
   *  Returns the default value.
   */
  static SbColorRGBA* getDefault();

protected:

  /** @copydoc SoElement::commonInit() */
  virtual void commonInit();

  /** Initializes element. */
  virtual void init(SoState *state);

  /** Returns TRUE if the attributes match in both elements */
  virtual SbBool matches(const SoElement* elt) const;

  /**
   *  Create and return a copy of this element.
   */
  virtual SoElement* copyMatchInfo() const;

SoINTERNAL public:
 
  // Initializes the SoTextTextureQualityRangeElement class
  static void initClass();
  static void exitClass();

protected:
  std::vector<SbColorRGBA> m_colors;

  virtual ~SoTextStyleColorsElement();

private:
   /** 
   * @return a color compute with colors from the current SoMaterial or from colors
   * (ie: SoTextProperty::styleColor field) according to SoTextStyleColorsMaterialUsageElement 
   */
  static void computeColors(SoState *state, const SbColorRGBA* inColors, std::vector<SbColorRGBA>& outColors);

  static std::vector<SbColorRGBA> s_defaultColors;
  static bool s_isSet;
};

#endif // SO_TEXT_EFFECTS_COLOR_ELEMENT


