/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_IMAGE_ELEMENT
#define  _SO_TEXTURE_IMAGE_ELEMENT

#include <Inventor/elements/SoTextureImageElementBase.h>

/**
*  Stores the current texture image.
* 
*  @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current texture image.
* 
*   @SEE_ALSO
*   SoTexture2, SoExtTexture2, SoIndexedTexture2, SoTextureCubeMap
*
*/

SoEXTENDER_Documented class INVENTOR_API SoTextureImageElement : public SoTextureImageElementBase
{ 
  SO_ELEMENT_HEADER(SoTextureImageElement);

public:
   /**
   * Gets the current image, wrap, and model.
   * [OIV-WRAPPER-ARG IN,OUT,OUT,OUT,WRAP_AS{int},OUT,OUT,OUT,OUT,IN]
   * [OIV-WRAPPER-RETURN-TYPE ARRAY{size.Value[0]*size.Value[1]*numComponents}]
   */
  static const void *get(SoState *state, SbVec2i32 &size, int &numComponents,
                         SoSFImage::DataType &dataType, 
                         GLint &GLInternalFormat,
                         int &wrapS, int &wrapT, int &model, 
                         SbColor &blendColor, int unit=0);
  /**
  * Gets the current image minFilter, magFilter and maxAnisotropy
  */
  static void get(SoState *state, int &_minFilter,int &_magFilter, float &_maxAnisotropy, int unit=0);

   /** Pass texname = -1 to deactivate subtexturing. Subtexturing not active
   * by default. In any case, the regular set method must be called.
   * [OIV-WRAPPER-ARG IN,IN,IN,IN,IN,ARRAY,IN]
   */
  static void set(SoState *state, SoNode *node,
                  const SbVec2i32 &subSize, int xoffset, int yoffset,
                  const void *buffer, int texname) ;
    
    
  /**
  *  Returns TRUE if the texture contains transparency info.
  */
  static SbBool       containsTransparency(SoState *state, int unit=0);
    
  /** Returns the default texture image.
   * [OIV-WRAPPER-ARG OUT,OUT,OUT,WRAP_AS{int}]
   * [OIV-WRAPPER-RETURN-TYPE ARRAY{s.Value[0]*s.Value[1]*nc}]
   */
  static const void *getDefault(SbVec2i32 &s, int &nc, SoSFImage::DataType &dataType,
                                GLint &GLInternalFormat);

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  /** Setup element according to given texture config */
  static void set(SoState *state, SoNode *node, const SoTexImageData& config);
};

#endif /* _SO_TEXTURE_IMAGE_ELEMENT */


