/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TEXTURE_NAME_ELEMENT
#define  _SO_TEXTURE_NAME_ELEMENT

#include <Inventor/SbString.h>
#include <Inventor/elements/SoReplacedElement.h>

/**
*   @VSGEXT Stores the current texture name.
* 
*   @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current texture name.
* 
*   @SEE_ALSO
*   SoCallbackAction
*/

SoEXTENDER_Documented class INVENTOR_API SoTextureNameElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(SoTextureNameElement);

 public:
  /**
  *  Sets the current texture name.
  */
  static void         set(SoState *state, SoNode *node,
                          const SbName &textureName);

  /**
  *  Returns the current texture name from the state.
  */
  static const SbName &get(SoState *state);

  /**
  *  Returns the default texture name.
  */
  static SbName       getDefault();

  /**
  *  Prints element (for debugging).
  */
  virtual void        print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

  /**
  *  Returns TRUE if the texture name matches given element.
  */
  virtual SbBool matches(const SoElement* elt) const;

  /**
  *  Create and return a copy of this element.
  */
  virtual SoElement* copyMatchInfo() const;

 SoINTERNAL public:
  // Initializes the SoTextureNameElement class
  static void         initClass();
  static void         exitClass();

 protected:
  SbName                      textureName;

  virtual ~SoTextureNameElement();
};

#endif /* _SO_TEXTURE_NAME_ELEMENT */


