/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : R. ALBOU (May 2002)
**=======================================================================*/

#ifndef  _SO_TEXTURE_UNIT_ELEMENT_
#define  _SO_TEXTURE_UNIT_ELEMENT_

#include <Inventor/SbPList.h>
#include <Inventor/elements/SoAccumulatedElement.h>

#ifdef _MSC_VER
#pragma warning( push )
#pragma warning(disable:4251)
#endif

/**
*   @VSGEXT Stores the current texture unit identifier.
*
*   @ingroup elements
*
*   @DESCRIPTION
*   This element stores the the current texture unit identifier.
*
*   @SEE_ALSO
*   SoTextureUnit
*/

SoEXTENDER_Documented class INVENTOR_API SoTextureUnitElement : public SoAccumulatedElement {
  SO_ELEMENT_HEADER(SoTextureUnitElement) ;

 public:
  /**
  *  Sets the current texture unit.
  */
  static void set(SoState *state, SoNode *node, int unit) ;

  /**
  *  Activates the current texture if it exists. Returned value indicates if it is successful.
  */
  static SbBool activateTextureUnit(SoState *state, int unit) ;

  /**
  *  Overrides push() method to copy values from next instance in the stack.
  */
  virtual void push(SoState *state) ;

  /**
  *  Pop method.
  */
  virtual void pop(SoState *, const SoElement *prevTopElement) ;

  /**
  *  Returns the current list texture units.
  */
  static const SbIntList& getTextureUnits(SoState *state) ;

  /**
  *  Returns the current active texture unit (the last texture unit set).
  */
  static int getActiveTextureUnit(SoState *state) ;

  /**
  *  Returns the maximum texture units.
  */
  static int getMaxTextureUnit(SoState* state=NULL) ;

  /**
  *  Returns TRUE if the multi-texturing is active: i.e., at least 2 texture units are defined.
  *  Returns also the list of units.
  */
  static SbBool isMultiTexturing(SoState *state, SbIntList &imageTexUnitList) ;

protected:

  /** Common Initialization. Directly called by the constructor. */
  virtual void commonInit();

  /** Initializes element. */
  virtual void init(SoState *state);

SoINTERNAL public:

  // Initializes the SoTextureUnitElement class
  static void initClass() ;
  static void exitClass() ;

  /**
   *  Returns the maximum texture units for the fixed pipeline .
   */
  static uint32_t getFixedPipelineMaxTextureUnit(SoState* state) ;

  /**
   * Return if active texture unit is in fixed pipeline
   */
  static bool isActiveTextureUnitInFixedPipeline(SoState* state);

  /**
   * Returns TRUE if multi-texturing is supported on the current context
   * Note: can be force disabled with OIV_MULTITEXTURING envvar
   */
  static SbBool isMultitexturingAvailable(SoState* state);

 protected:
  // Sets the element
  virtual void setElt(SoState* state, SoNode *node, const int unit) ;
  virtual void setUnit(SoState* state, const int unit);

  int       m_startIndex ;
  int       m_textureUnit ;

  // List of texture units
  SbIntList m_textureUnits ;

  virtual ~SoTextureUnitElement() ;

  virtual SbBool matches(const SoElement* element) const;
  virtual SoElement* copyMatchInfo() const;

private:
  // used to indicate that multitexturing has been disable through OIV_MULTITEXTURING envvar
  static SbBool s_multiTexturingAllowed;
} ;
/*----------------------------------------------------------------------------*/

#ifdef _MSC_VER
#pragma warning( pop )
#endif

#endif // _SO_TEXTURE_UNIT_ELEMENT_


