/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _SO_UNIFORM_SHADER_PARAMETER_ELEMENT_
#define  _SO_UNIFORM_SHADER_PARAMETER_ELEMENT_

#include <Inventor/fields/SoMFNode.h> 
#include <Inventor/SbPList.h>
#include <Inventor/elements/SoAccumulatedElement.h>

class SoShaderParameter;
class SoUniformShaderParameter;

/*----------------------------------------------------------------------------*/

/**
*   @VSGEXT Stores the current uniform shader parameter.
* 
*   @ingroup elements
* 
*   @DESCRIPTION
*   This element stores the current uniform shader parameter.
* 
*   @SEE_ALSO
*   SoShaderParameter
*/
SoEXTENDER_Documented class INVENTOR_API SoUniformShaderParameterElement : public SoAccumulatedElement {
  SO_ELEMENT_HEADER(SoUniformShaderParameterElement) ;

public:
  /**
  *  Adds a shader parameter.
  */
  static void add( SoState* state, SoShaderParameter* param );

//#if SoDEPRECATED_BEGIN( 1000 )
  SoDEPRECATED_METHOD( 1000, "Use the add() without a SoMFNode as last parameter." )
  static void add( SoState* state, SoShaderParameter* param, SoMFNode* shaderObjects );
//#endif /** @DEPRECATED_END */

  /**
  *  Overrides push() method to copy values from next instance in the stack.
  */
  virtual void push(SoState *state) ;

  /**
  *  Returns the top (current) instance of the element in the state.
  */
  static const SoUniformShaderParameterElement *getInstance(SoState *state);

  /** @copydoc SoElement::pop(SoState*, const SoElement*) */
  virtual void pop(SoState* state, const SoElement* prevTopElement);

protected:

  /** Initializes element. */
  virtual void init(SoState *state);

  SoINTERNAL public:

  // Initializes the SoUniformShaderParameterElement class
  static void initClass() ;
  static void exitClass() ;

  /** Fill given vector with all on state parameters */
  static void getParameters(SoState* state, std::vector<SoUniformShaderParameter*>& shaderParameters);
  
protected:
  //List of SoUniformShaderParameter
  SoNodeList parameters;

  virtual ~SoUniformShaderParameterElement() ;
} ;
/*----------------------------------------------------------------------------*/

#endif // _SO_UNIFORM_SHADER_PARAMETER_ELEMENT_


