/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_VIEW_VOLUME_ELEMENT
#define  _SO_VIEW_VOLUME_ELEMENT

#include <Inventor/SbLinear.h>
#include <Inventor/elements/SoReplacedElement.h>

/**
* Stores the current view volume.
*
*   @ingroup elements
*
*   @DESCRIPTION
*   This element stores the current view volume.
*
* @warning Open Inventor does not guarantee that the view volume element corresponds
* to the current view and projection matrix elements used for rendering. A node could,
* for example, set the SoProjectionMatrixElement but not the SoViewVolumeElement. An 
* example of this is the SoDepthOffset node. If you need these matrices, it is safer 
* to access them through the SoViewingMatrixElement and SoProjectionMatrixElement.
* Cameras nodes do set the view volume and both matrix elements on a render traversal.
*
*   @SEE_ALSO
*   SoCamera, SoOrthographicCamera, SoPerspectiveCamera
*/

SoEXTENDER_Documented class INVENTOR_API SoViewVolumeElement : public SoReplacedElement {

  SO_ELEMENT_HEADER(SoViewVolumeElement);

 public:
  /**
  *  Sets the view volume in the state.
  */
  static void set(SoState *state, SoNode *node, const SbViewVolume &viewVolume);

  /**
  *  Returns the current view volume from the state.
  */
  static const SbViewVolume & get(SoState *state);

  /**
  *  Returns TRUE if the view volume has been set in the state.
  */
  static SbBool isSet(SoState *state);

  /**
  *  Prints element (for debugging).
  */
  virtual void print(FILE *fp) const;

protected:

  /** Initializes element */
  virtual void init(SoState *state);

 SoINTERNAL public:
  /** Return the eye position in object space */
  static SbVec3f getEyePosObjectSpace(SoState* state);
  static SbVec3f getEyePosObjectSpace(const SbMatrix& modelViewMatrix);

  // Initializes the SoViewVolumeElement class
  static void         initClass();
  static void         exitClass();

 protected:
  SbBool              volumeWasSet;
  SbViewVolume        viewVolume;

  virtual ~SoViewVolumeElement();
};

#endif /* _SO_VIEW_VOLUME_ELEMENT */


