/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_GATE_
#define  _SO_GATE_

#include <Inventor/SoDB.h>
#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFName.h>
#include <Inventor/fields/SoSFTrigger.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoGate
//
//  Gate engine class. A gate engine copies its input to its output,
//  when the "enable" field is true.  It will also do a one-time copy
//  when the trigger field is touched.
//
//////////////////////////////////////////////////////////////////////////////


/**
* Selectively copies its input to its output.
* 
* @ingroup engines
* 
* @DESCRIPTION
*   This engine selectively copies its input to its output. The type of the input
*   field can be any subclass of SoMField. The type is specified when an instance of
*   the class is created. For example, SoGate(\if_cpp SoMFFloat::getClassTypeId()\endif 
*   \if_dotnet typeof(SoMFFloat)\endif \if_java SoMFFloat.getClass()\endif )
*   creates an engine that copies floating-point values.
*   
*   The #enable input controls continuous flow-through of values. While
*   #enable is TRUE, the input will be copied to the output. Alternatively, by
*   touching the #trigger input, you can copy a single value from the input to
*   the output.
*   
*   Note that by default #input does not contain any values.
*   \if_cpp
*   Note also that unlike most other engine fields, #input and #output are
*   pointers. 
*   \endif
* 
* @FILE_FORMAT_DEFAULT
*    Gate {
*    @TABLE_FILE_FORMAT
*       @TR type      @TD \<inputType\>
*       @TR input     @TD []
*       @TR enable    @TD FALSE
*       @TR trigger   @TD 
*    @TABLE_END
*    }
* 
* @SEE_ALSO
*    SoEngineOutput,
*    SoConcatenate,
*    SoSelectOne
* 
* [OIVNET-WRAPPER-CLASS SEALED]
*/ 
class INVENTOR_API SoGate : public SoEngine {
  
  SO_ENGINE_HEADER(SoGate);
  
 public:
  /**
   * Constructor. The argument specifies the type of the input field.
   */
  SoGate(SoType mfInputType);

  /**
   * Enable continous flow-through. 
   */
  SoSFBool enable;
  /**
   * Copy a single value. 
   */
  SoSFTrigger trigger;

  /**
   * The value that is copied to the output when the gate is open. 
   */
  SoMField *input;

  /**
   * ( lt )  Contains a copy of the input value if the gate is open.
   */
  SoEngineOutput *output;

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

  // Copies an instance that is encountered through a field connection
  virtual SoFieldContainer *copyThroughConnection() const;
  
 protected:
  ~SoGate();
  virtual void inputChanged(SoField *whichInput);
  
  // Copies the contents of the given node into this instance
  virtual void copyContents(const SoFieldContainer *fromFC,
                            SbBool copyConnections);

  /** @copydoc SoEngine::evaluate() */
  virtual void evaluate();

 private:
  SoGate();
  
  // gate engines must write out their input type before writing
  // their fields, so these are overridden:
  virtual SbBool readInstance(SoInput *in, unsigned short flags);
  virtual void writeInstance(SoOutput *out);
  
  void setup(SoType);
  
  int conversionCase;
  
  SoFieldData *myInputData;
  SoEngineOutputData *myOutputData;
  
  SoSFName typeField; // Used when reading/writing
};

#endif /* _SO_GATE_ */

