/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_ON_OFF_
#define  _SO_ON_OFF_

#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoSFTrigger.h>

/**
 * Engine that functions as an on/off switch.
 * 
 * @ingroup engines
 * 
 * @DESCRIPTION
 *   This engine has three triggers as input and two Boolean values as output. The
 *   #isOn output is a switch that can be turned #on or #off by
 *   triggering the corresponding input. You can toggle the value by triggering the
 *   #toggle input. By default #isOn is FALSE. The #isOff output
 *   value is the inverse of #isOn
 * 
 * @FILE_FORMAT_DEFAULT
 *    OnOff {
 *    @TABLE_FILE_FORMAT
 *       @TR on       @TD 
 *       @TR off      @TD 
 *       @TR toggle   @TD 
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *    SoEngineOutput
 * 
 * 
 */
class INVENTOR_API SoOnOff : public SoEngine {

  SO_ENGINE_HEADER(SoOnOff);
    
 public:

  /**
   * Turn the isOn switch on. 
   */
  SoSFTrigger on;
  /**
   * Turn the isOn switch off. 
   */
  SoSFTrigger off;
  /**
   * Toggle the switch value. 
   */
  SoSFTrigger toggle;
    
  /**
   * ( SoSFBool )  Switch value.
   */
  SoEngineOutput isOn;
  /**
   * ( SoSFBool )  The inverse of isOn.
   */
  SoEngineOutput isOff;
    
  /**
   * Constructor.
   */
  SoOnOff();
    
 SoINTERNAL public:

  static void initClass();
  static void exitClass();

 protected:
  virtual void        inputChanged(SoField *whichInput);
  
  // Evaluation method
  virtual void evaluate();

  // Destructor
  ~SoOnOff();

 private:
  SbBool      state;
};

#endif  /* _SO_ON_OFF_ */

