/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SELECTONE_
#define  _SO_SELECTONE_

#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/fields/SoSFName.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoSelectOne
//
//  Class that select a single value from a multiple-valued field.
//
//////////////////////////////////////////////////////////////////////////////

/**
* Selects one value from a multiple-value field.
* 
* @ingroup engines
* 
* @DESCRIPTION
*   This engine selects a single value from a multiple-value field, based on the
*   input field #index. The type of the input field can be any subclass of
*   SoMField, and the type of the output is the corresponding subclass of SoSField.
*   For example, if the input type is SoMFVec3f, the output type will be SoSFVec3f.
*   The type is specified when an instance of the class is created. For example,
*   SoSelectOne(\if_cpp SoMFFloat::getClassTypeId()\endif \if_dotnet typeof(SoMFFloat)\endif
*   \if_java SoMFFloat.getClass()\endif ) creates an engine that selects one
*   floating-point value.
*   
*   Note that by default #input does not contain any values, 
*   and no value is output from the engine.
*   \if_cpp
*   Note that unlike most other engine fields, the #input field and
*   #output are pointers. 
*   \endif
* 
* @FILE_FORMAT_DEFAULT
*    SelectOne {
*    @TABLE_FILE_FORMAT
*       @TR type    @TD \<inputType\>
*       @TR input   @TD []
*       @TR index   @TD 0
*    @TABLE_END
*    }
* 
* @SEE_ALSO
*    SoEngineOutput,
*    SoConcatenate,
*    SoGate
* 
* [OIVNET-WRAPPER-CLASS SEALED]
*/ 
class INVENTOR_API SoSelectOne : public SoEngine {
  
  SO_ENGINE_HEADER(SoSelectOne);
  
 public:
  /**
   * Constructor. The argument specifies the type of the multiple-value input field.
   */
  SoSelectOne(SoType mfInputType);

  /**
   * Index of the value to select from the multiple-value field. 
   */
  SoSFInt32 index;

  /**
   * The multiple-value field from which the value will be selected. 
   */
  SoMField *input;

  /**
   * ( lt )  The single value selected.
   */
  SoEngineOutput *output;

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

  // Copies an instance that is encountered through a field connection
  virtual SoFieldContainer *copyThroughConnection() const;

 protected:
  ~SoSelectOne();

  /** @copydoc SoEngine::evaluate() */
  virtual void evaluate();

 private:
  SoSelectOne();
  
  // SelectOne engines must write out their input type before writing
  // their fields, so these are overridden:
  virtual SbBool readInstance(SoInput *in, unsigned short flags);
  virtual void writeInstance(SoOutput *out);
  
  void setup(SoType);
  
  int conversionCase;
  
  SoFieldData *myInputData;
  SoEngineOutputData *myOutputData;
  
  SoSFName typeField; // Used when reading/writing
};

#endif /* _SO_SELECTONE_ */

