/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Ronen Barzel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_TRIGGER_ANY_
#define  _SO_TRIGGER_ANY_

#include <Inventor/engines/SoSubEngine.h>
#include <Inventor/fields/SoSFTrigger.h>

/**
 * Provides fan-in for triggers.
 * 
 * @ingroup engines
 * 
 * @DESCRIPTION
 *   This engine takes up to 10 input triggers, and produces one trigger output. The
 *   output is triggered whenever one of the inputs is touched.
 * 
 * @FILE_FORMAT_DEFAULT
 *    TriggerAny {
 *    @TABLE_FILE_FORMAT
 *       @TR input0   @TD 
 *       @TR input1   @TD 
 *       @TR input2   @TD 
 *       @TR input3   @TD 
 *       @TR input4   @TD 
 *       @TR input5   @TD 
 *       @TR input6   @TD 
 *       @TR input7   @TD 
 *       @TR input8   @TD 
 *       @TR input9   @TD 
 *    @TABLE_END
 *    }
 * 
 * @SEE_ALSO
 *    SoEngineOutput,
 *    SoSFTrigger
 * 
 * 
 */
class INVENTOR_API SoTriggerAny : public SoEngine {

  SO_ENGINE_HEADER(SoTriggerAny);

 public:
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                 input0;
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                 input1;
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                 input2;
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                 input3;
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                 input4;
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                 input5;
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                 input6;
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                 input7;
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                 input8;
  /**
   *  The output is triggered whenever one of the inputs is touched.
   */
  SoSFTrigger                  input9;
  /**
   *  Triggered when any of the inputs is touched.
   */
  SoEngineOutput              output;

  /**
   * Constructor
   */
  SoTriggerAny();

 SoINTERNAL public:
  static void                 initClass();
  static void                 exitClass();

 protected:
  ~SoTriggerAny();
 
  virtual void                evaluate();
};

#endif  /* _SO_TRIGGER_ANY_ */

