/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/


#ifndef __SB_EXCEPTION__
#define __SB_EXCEPTION__

#include <Inventor/STL/exception>
#include <Inventor/STL/string>

/**
*  
* Generic standard exception.
* 
* @DESCRIPTION
* This is the base class of all Open Inventor exceptions.
* Should be derived for custom usage.
* Should be used instead of std::exception for portable code.
*
*/ 
SoINTERNAL class SbException : public std::exception
{
public:
  /**
   * Constructs the exception with the given message.
   * @param what a string to explain the exception.
   */
  SbException(const char *const& what) : m_what(what) {}

  /**
   * Destructor.
   */
  virtual ~SbException() throw() {}

  /**
   * Returns the exception message.
   * @return The exception message.
   */
  virtual const char* what() const throw() { return m_what.toLatin1(); }

private:

  /** Prevent copy */
  SbException& operator=(const SbException&) { return *this; }

  const SbString m_what;
};

#endif // __SB_EXCEPTION__

