/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Feb 2010)
**=======================================================================*/

#ifndef  _SO_GL_ERROR
#define  _SO_GL_ERROR

#include <Inventor/SbBasic.h>
#include <Inventor/errors/SoError.h>

/**
 * OpenGL rendering error handling.
 *
 * @ingroup errors
 *
 * @DESCRIPTION
 *   SoGLError is used for errors reported by the OpenGL render engine. @BR
 *   See SoError for full discussion of error handling in Open Inventor.
 *
 * @SEE_ALSO
 *    SoDebugError,
 *    SoMemoryError
 */
class INVENTORGL_API SoGLError : public SoError {

 public:
  /**
   * Sets handler callback for SoGLError class.
   *
   * @B Note:@b the handler callback is reset to the default handler
   * callback by method SoWin::finish.
   */
  static void setHandlerCallback(SoErrorCB *cb, void *data);

  /**
   * Returns handler callback for SoGLError class.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static SoErrorCB* getHandlerCallback();

  /**
   * Returns handler data for SoGLError class.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void* getHandlerData();

  /**
   * Returns type identifier for the SoGLError class.
   */
  static SoType getClassTypeId();

  /**
   * Returns type identifier for an instance of this class.
   */
  virtual SoType getTypeId() const;

  /**
   * Posts an error
   */
  SoPRINTFPREFIX(3, 4) static void post(const int openGLErrorCode , const char* glFuncName, const char *formatString ...);

 SoINTERNAL public:
  // Initializes SoGLError class
  static void initClass();
  static void exitClass();
  static SoErrorCB* getDefaultHandlerCB() { return defaultHandlerCB; }

 protected:
  // Returns handler callback (and data) to use for a given instance
  virtual SoErrorCB* getHandler(void *&data) const;
  virtual bool isInit() const;

 private:
  // Type id of SoGLError class
  static SoType classTypeId;
  // Handler callback for class
  static SoErrorCB* handlerCB;
  // User data for callback
  static void* cbData;
  // TRUE if handler initialized
  static SbBool wasInitted;
};

#endif /* _SO_GL_ERROR */


