/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_READ_ERROR
#define  _SO_READ_ERROR

#include <Inventor/SbBasic.h>
#include <Inventor/errors/SoError.h>

class SoInput;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoReadError
//
//  This class is used for all errors reported while reading Inventor
//  data files.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Read error handling.
 *
 * @ingroup errors
 *
 * @DESCRIPTION
 *   SoReadError is used for errors reported while reading files. @BR
 *   See SoError for full discussion of error handling in Open Inventor.
 *
 * @SEE_ALSO
 *    SoDebugError,
 *    SoMemoryError,
 *    SoGLError
 */
class INVENTOR_API SoReadError : public SoError {

 public:
  /**
   * Sets handler callback for SoReadError class.
   *
   * @B Note:@b the handler callback is reset to the default handler
   * callback by method SoWin::finish.
   */
  static void setHandlerCallback(SoErrorCB *cb, void *data);

  /**
   * Returns handler callback for SoReadError class.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static SoErrorCB* getHandlerCallback();

  /**
   * Returns handler data for SoReadError class.
   * [OIV-WRAPPER-NO-WRAP]
   */
  static void* getHandlerData();

  /**
   * Returns type identifier for SoReadError class.
   */
  static SoType getClassTypeId();

  /**
   * Returns type identifier for error instance
   */
  virtual SoType getTypeId() const;

  /**
   * Posts an error
   */
  SoPRINTFPREFIX(2,3) static void post(const SoInput *in, const char *formatString ...);

 SoINTERNAL public:
  // Initializes SoReadError class
  static void initClass();
  static void exitClass();
  static SoErrorCB* getDefaultHandlerCB() { return defaultHandlerCB; }

 protected:
  // Returns handler callback (and data) to use for a given instance
  virtual SoErrorCB* getHandler(void *&data) const;
  virtual bool isInit() const;

 private:
  // Type id of SoReadError class
  static SoType classTypeId;
  // Handler callback for class
  static SoErrorCB* handlerCB;
  // User data for callback
  static void* cbData;
  // TRUE if handler initialized
  static SbBool wasInitted;
};

#endif /* _SO_READ_ERROR */


