/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_MF_BIT_MASK_
#define  _SO_MF_BIT_MASK_

#include <Inventor/fields/SoMFEnum.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoMFBitMask subclass of SoMEnum
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Multiple-value field containing any number of masks of bit flags.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   A multiple-value field that contains any number of masks of bit flags, stored as
 *   ints. Nodes or engines that use this field class define mnemonic names for the
 *   bit flags. These names should be used when setting or testing the values of the
 *   field, even though the values are treated as integers in the methods.
 *   
 *   The bit-wise "&" and "|" operators should be used when testing and setting flags
 *   in a mask.
 *   
 *   SoMFBitMasks are written to file as one or more mnemonic enumerated type names,
 *   in this format:
 *   
 *   \verbatim
      ( flag1 | flag2 | ... )
     \endverbatim
 *    If only one flag is used in a mask, the parentheses are optional. These
 *   names differ among uses of this field in various node or engine classes. See the
 *   reference pages for specific nodes or engines for the names.
 *   
 *   The field values may also be represented as integers, but this is not guaranteed
 *   to be portable.
 *   
 *   When more than one value is present, all of the values are enclosed in square
 *   brackets and separated by commas.
*   
*   @B Data copying:@b
*   \par
*   SoMF fields are a kind of "smart container", automatically expanding as necessary
*   to hold the data provided by the application. This is very convenient, but for large
*   blocks of data it may be desireable to avoid making a copy of the application data.
*   The \if_cpp setValuesPointer() \else \if_dotnet SetValuesBuffer() \else setValuesBuffer() \endif \endif
*   methods allow Open Inventor to directly use an array of values supplied by the application.
*   The application data is not copied.  Please see SoMFVec3f for more information and example code.
 * 
 * [OIVNET-WRAPPER-CLASS CUSTOM_CODE]
 */
class INVENTOR_API SoMFBitMask : public SoMFEnum {
  // Use standard field stuff for derived class;
  // the rest is inherited from SoMFEnum
  SO_MFIELD_DERIVED_HEADER(SoMFBitMask, int, int);
  SO_MFIELD_SETVALUESPOINTER_HEADER(int);
    
    protected:
  // Looks up enum name, returns value. Returns FALSE if not found.
  virtual SbBool findEnumValue(const SbName &name, int &val);
  
 SoINTERNAL public:
  static void initClass();
  static void exitClass();

};

#endif /* _SO_MF_BIT_MASK_ */

