/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_MF_ROTATION_
#define  _SO_MF_ROTATION_

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbLinear.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoMFRotation subclass of SoMField.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Multiple-value field containing any number of SbRotations.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   A multiple-value field that contains any number of SbRotations.
 *   
 *   SoMFRotations are written to file as one or more sets of four floating point
 *   values. Each set of 4 values is an axis of rotation followed by the amount of
 *   right-handed rotation about that axis, in radians.
 *   
 *   When more than one value is present, all of the values are enclosed in square
 *   brackets and separated by commas; for example:
 *   
 *   \verbatim
      [ 1 0 0 0, -.707 -.707 0 1.57 ]
     \endverbatim
 *
 *   @B Data copying:@b
 *   \par
 *   SoMF fields are a kind of "smart container", automatically expanding as necessary
 *   to hold the data provided by the application. This is very convenient, but for large
 *   blocks of data it may be desireable to avoid making a copy of the application data.
 *   The \if_cpp setValuesPointer() \else \if_dotnet SetValuesBuffer() \else setValuesBuffer() \endif \endif
 *   methods allow Open Inventor to directly use an array of values supplied by the application.
 *   The application data is not copied.  Please see SoMFVec3f for more information and example code.
 *    
 * 
 * @SEE_ALSO
 *    SbRotation
 * 
 * 
 */
class INVENTOR_API SoMFRotation : public SoMField {

  // Use standard field stuff
  SO_MFIELD_HEADER(SoMFRotation, SbRotation, const SbRotation &);
  SO_MFIELD_SETVALUESPOINTER_HEADER(SbRotation);

    public:

  //
  // Some additional convenience functions:
  //
  /**
   * \if_java
   * Sets values from the specified array of floats.
   * The size of the array must be a multiple of 4.
   * \else
   * Sets values from an array of arrays of 4 floats.
   * \endif
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValues(start, num)}]
   * [OIVJAVA-WRAPPER-ARG IN,NO_WRAP{(num)},IN]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{int num = q != null ? q.length/4 : 0; onSetValues(start, num)}]
   */
  void setValues(int start, int num, const float q[][4]);

  /**
   * Sets the @B index @b'th value to the given quaternion (x, y, z, w).
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN,IN,IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void set1Value(int index, float q0, float q1, float q2, float q3);

  /**
   * Sets the @B index @b'th value to the given quaternion (x, y, z, w).
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void set1Value(int index, const float q[4]);

  /**
   * Sets the @B index @b'th value to the given axis/angle.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN,IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void set1Value(int index, const SbVec3f &axis, float angle);

  /**
   * Makes this field have exactly one value, given by the quaternion (x, y, z, w).
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void setValue(float q0, float q1, float q2, float q3);

  /**
   * Makes this field have exactly one value, given by the quaternion (x, y, z, w).
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void setValue(const float q[4]);

  /**
   * Makes this field have exactly one value, given by @B axis @b and @B angle @b.
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void setValue(const SbVec3f &axis, float angle);

  /**
   * Sets the @B index @b'th value in the array to @B newValue @b, a double
   * precision rotation. The array will be automatically expanded, if necessary. Note
   * that Open Inventor fields still store only single precision values, not double
   * precision values. The specified value is converted to single precision, then
   * stored.
   * [OIVNET-WRAPPER-ARG INDEX{0,},IN]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSet1Value(index)}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSet1Value(index)}]
   */
  void set1Value(int index, const SbRotationd &rd);

  /**
   * Sets the first value in the array to @B newValue @b, a double precision
   * rotation, and deletes the second and subsequent values. Note that Open Inventor
   * fields still store only single precision values, not double precision values.
   * The specified value is converted to single precision, then stored.
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValue()}]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{onSetValue()}]
   */
  void setValue(const SbRotationd &rd);

  /**
   * \if_cpp
   * Sets @B num @b values starting at index @B start @b to the values in
   * @B newValues @b, an array of double precision rotations.
   * \else
   * Sets values starting at index @B start @b to the values in
   * the specified array of double precision rotations.
   * \endif
   * The array will automatically be made larger to accommodate the new values, if necessary.
   * Note that Open Inventor fields still store only single precision values, not double
   * precision values. The specified values are converted to single precision, then
   * stored.
   * [OIVNET-WRAPPER-ARG INDEX{0,},NO_WRAP{rd->Length},ARRAY]
   * [OIVNET-WRAPPER-HELPER BEGIN{OnSetValues(start, rd->Length)}]
   * [OIVJAVA-WRAPPER-ARG IN,NO_WRAP{(num)},ARRAY]
   * [OIVJAVA-WRAPPER HELPER_BEGIN{int num = rd != null ? rd.length : 0; onSetValues(start, num)}]
   */
  void setValues(int start, int num, const SbRotationd *rd);

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

};

#endif /* _SO_MF_ROTATION_ */

