/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Oct 2006)
**=======================================================================*/


#ifndef  _SO_MF_VEC2STRING_
#define  _SO_MF_VEC2STRING_

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbVec2String.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoMFVec2String subclass of SoMField.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Multiple-value field containing any number of two-dimensional string vectors.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   A multiple-value field that contains any number of two-dimensional string vectors.
 *   
 *   SoMFVec2String are written to file as one or more pairs of SbString point values
 *   separated by whitespace. When more than one value is present, all of the values
 *   are enclosed in square brackets and separated by commas. When a string value 
 *   contains a white space it should be enclosed by double quote for example:
 *   
 *   \verbatim
      [ toto truc, "hello man" test ]
     \endverbatim
 *
 *   @B Data copying:@b
 *   \par
 *   SoMF fields are a kind of "smart container", automatically expanding as necessary
 *   to hold the data provided by the application. This is very convenient, but for large
 *   blocks of data it may be desireable to avoid making a copy of the application data.
 *   The \if_cpp setValuesPointer() \else \if_dotnet SetValuesBuffer() \else setValuesBuffer() \endif \endif
 *   methods allow Open Inventor to directly use an array of values supplied by the application.
 *   The application data is not copied.  Please see SoMFVec3f for more information and example code.
 * 
 */
class INVENTOR_API SoMFVec2String : public SoMField {

  // Use standard field stuff
  SO_MFIELD_HEADER(SoMFVec2String, SbVec2String, const SbVec2String &);
  SO_MFIELD_SETVALUESPOINTER_HEADER(SbVec2String);
  
public:
  //
  // Some additional convenience functions:
  //
  
  /**
   * Sets one value from 2 SbString.
   */
  void set1Value(int index, SbString s1, SbString s2);
  
  /**
   * Sets one vector value from an array of 2 SbString.
   */
  void set1Value(int index, const SbString ss[2]);
  
  /**
   * Sets to one value from 2 SbString.
   */
  void setValue(SbString s1, SbString s2);
  /**
   * Sets to one vector value from array of 2 SbString
   */
  void setValue(const SbString ss[2]);

SoINTERNAL public:
  static void   initClass();
  static void   exitClass();
};

#endif /* _SO_MF_VEC2STRING_ */


