/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SF_BIT_MASK_
#define  _SO_SF_BIT_MASK_

#include <Inventor/fields/SoSFEnum.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFBitMask subclass of SoSField.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Single-value field containing a set of bit flags.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   A single-value field that contains a mask of bit flags, stored as an integer.
 *   Nodes that use this field class define mnemonic names for the bit flags. These
 *   names should be used when setting or testing the values of the field, even
 *   though the values are treated as integers in the methods.
 *   
 *   The bit-wise "&" and "|" operators should be used when testing and setting flags
 *   in a mask. For example:
 *   \if_cpp
 *     \code
 *     // Add sides to the set of parts rendered
 *     text3->parts = text3->parts.getValue() | SoText3::SIDES;
 *
 *     // Remove sides from the set of parts rendered
 *     text3->parts = text3->parts.getValue() & ~SoText3::SIDES;
 *     \endcode
 *   \endif
 *   \if_dotnet
 *     \code
 *     // Add sides to the set of parts rendered
 *     text.parts.Value = text.parts.Value | SoText3.PartType.SIDES;
 *
 *     // Remove sides from the set of parts rendered
 *     text.parts.Value = text.parts.Value & ~SoText3.PartType.SIDES;
 *     \endcode
 *   \endif
 *   \if_java
 *     \code
 *     // Add sides to the set of parts rendered
 *     text.parts.setValue( text.parts.getValue() | SoText3.PartType.SIDES.getValue() );
 *
 *     // Remove sides from the set of parts rendered
 *     text.parts.setValue( text.parts.getValue() & ~SoText3.PartType.SIDES.getValue() );
 *     \endcode
 *   \endif
 *   SoSFBitMasks are written to file as one or more mnemonic enumerated type
 *   names, in this format:
 *   
 *   \code
 *    ( flag1 | flag2 | ... )
 *    \endcode
 *    If only one flag is used in a mask, the parentheses are optional. These
 *   names differ among uses of this field in various node or engine classes. See
 *   their reference pages for the names.
 *   
 *   The field values may also be represented as integers, but this is not guaranteed
 *   to be portable.
 * 
 * @SEE_ALSO
 *    SoField,
 *    SoSField,
 *    SoMFBitMask
 * 
 * [OIVNET-WRAPPER-CLASS CUSTOM_CODE]
 */
class INVENTOR_API SoSFBitMask : public SoSFEnum {

  // Use standard field stuff for derived class;
  // the rest is inherited from SoSFEnum
  SO_SFIELD_DERIVED_HEADER(SoSFBitMask, int, int);

  // Inherits other stuff from Enum field

 protected:
  // Looks up enum name, returns value. Returns FALSE if not found.
  virtual SbBool      findEnumValue(const SbName &name, int &val);

 SoINTERNAL public:
  static void         initClass();
  static void exitClass();

};

#endif /* _SO_SF_BIT_MASK_ */

