/*=================================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                 ***
 ***                                                                            ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS   ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR   ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                       ***
 ***                                                                            ***
 ***                        RESTRICTED RIGHTS LEGEND                            ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS  ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN  ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT  ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN  ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         ***
 ***                                                                            ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                    ***
 ***                              BORDEAUX, FRANCE                              ***
 ***                            ALL RIGHTS RESERVED                             ***
 =================================================================================*/

#ifndef SO_SF_BOX2F_H
#define SO_SF_BOX2F_H

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbLinear.h>
#include <Inventor/SbBox.h>

/**
 * @VSGEXT Field containing a two-dimensional box.
 *
 * @ingroup fields
 *
 * @DESCRIPTION
 *   This field defines a two-dimensional box.
 *
 *   SoSFBox2f fields are written to file as 4 floats separated by whitespace.
 *
 * @SEE_ALSO
 *    SoField,
 *    SoSField
 */
class INVENTOR_API SoSFBox2f : public SoSField
{
  // Use standard field stuff
  SO_SFIELD_HEADER(SoSFBox2f, SbBox2f, const SbBox2f&);

public:

  /**
   * Sets the box dimensions.
   */
  void setValue( float xmin, float ymin, float xmax, float ymax );

  /**
   * Sets the box dimensions.
   */
  void setValue( const SbVec2f& min, const SbVec2f& max );

SoINTERNAL public:
  static void initClass();
  static void exitClass();
};

#endif /* SO_SF_BOX2F_H */
