/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : M. PAPILLON (May 2016)
**=======================================================================*/

#ifndef  _SO_SF_BOX4I32_
#define  _SO_SF_BOX4I32_

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbLinear.h>

#include <Inventor/SbBox.h> // To Suppress in the VERSION

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFBox4i32 subclass of SoSField.
//
//////////////////////////////////////////////////////////////////////////////


/**
 * @VSGEXT Field containing a four-dimensional box (spacial three-dimension + time dimension).
 *
 * @ingroup fields
 *
 * @DESCRIPTION
 *   This field defines a three-dimensional box.
 *
 *   SoSFBox4i32 fields are written to file as 8 integers separated by whitespace.
 *
 * @SEE_ALSO
 *    SoField,
 *    SoSField
 */
class INVENTOR_API SoSFBox4i32 : public SoSField
{
  // Use standard field stuff
  SO_SFIELD_HEADER( SoSFBox4i32, SbBox4i32, const SbBox4i32& );

public:
  //
  // Some additional convenience functions:
  //

  /**
   * Sets the box dimensions.
   */
  void                setValue( int xmin, int ymin, int zmin, int tmin,
                                int xmax, int ymax, int zmax, int tmax );

  /**
   * Sets the box dimensions.
   */
  void                setValue( const SbVec4i32& _min, const SbVec4i32& _max );

SoINTERNAL public:
  static void         initClass();
  static void         exitClass();
};

#endif /* _SO_SF_BOX3I32_ */
