/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SF_COLOR_
#define  _SO_SF_COLOR_

#include <Inventor/fields/SoSubField.h>
#include <Inventor/SbColor.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFColor subclass of SoSField.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Field containing an RGB color.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   A single-value field containing an SbColor. Values may be set in either RGB
 *   (red, green, blue) or HSV (hue, saturation, value) color spaces.
 *   
 *   SoSFColors are written to file as an RGB triple of floating point numbers in
 *   standard scientific notation, in the range 0.0 to 1.0.
 * 
 * @SEE_ALSO
 *    SoField,
 *    SoSField,
 *    SoMFColor,
 *    SbColor
 * 
 * 
 */
class INVENTOR_API SoSFColor : public SoSField {

  // Use standard field stuff
  SO_SFIELD_HEADER(SoSFColor, SbColor, const SbColor &);

 public:
  //
  // Some additional convenience functions
  //

  /**
   * Convenience method for setting the value.
   */
  void setValue(const SbVec3f &vec);

  /**
   * Convenience method for setting the value.
   */
  void setValue(float r, float g, float b);

  /**
   * Convenience method for setting the value.
   */
  void setHSVValue(float h, float s, float v);

  /**
   * Convenience method for setting the value.
   */
  void setValue(const float rgb[3]);

  /**
   * Convenience method for setting the value.
   */
  void setHSVValue(const float hsv[3]);

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

};

#endif /* _SO_SF_COLOR_ */

