/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Nicolas DAGUISE (Jul 2007)
**=======================================================================*/


#ifndef  _SO_SF_INT64_
#define  _SO_SF_INT64_

#include <Inventor/fields/SoSubField.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFInt64 subclass of SoSField.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Field containing a int64_t integer.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   A field containing a single long (64-bit) integer.
 *   
 *   SoSFInt64s are written to file as an integer in decimal, hexadecimal (beginning
 *   with '0x') or octal (beginning with '0') format.
 * 
 * @SEE_ALSO
 *    SoField,
 *    SoSField,
 *    SoMFInt64
 * 
 * 
 */
class INVENTOR_API SoSFInt64 : public SoSField {

  // Use standard field stuff
  SO_SFIELD_HEADER(SoSFInt64, int64_t, int64_t);

 SoINTERNAL public:

  static void initClass();
  static void exitClass();

};

#endif /* _SO_SF_INT32_ */

