/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SF_NODE_
#define  _SO_SF_NODE_

class SoNode;

#include <Inventor/fields/SoSubField.h>

//////////////////////////////////////////////////////////////////////////////
//
//  SoSFNode subclass of SoSField. The field value is a pointer to an
//  SoNode. The field automatically maintains a reference to the node
//  it points to and propagates notification from the node.
//
//////////////////////////////////////////////////////////////////////////////

/**
* Field containing a a node.
* 
* @ingroup fields
* 
* @DESCRIPTION
*   This field maintains a an SoNode instance\if_cpp, correctly maintaining its
*   reference counts \endif\.
*   
*   SoSFNodes are written to file as the node they are containing. For example:
*   
*   \verbatim
     mySoSFNodeField Cube {}
    \endverbatim
*    is an SoSFNode field named 'mySoSFNodeField', referring to an SoCube node.
*   If the node is used elsewhere, the regular DEF/USE instancing mechanism
*   applies:
*   
*   \verbatim
     anotherSoSFNodeField USE topSeparator
    \endverbatim
*    is an SoSFNode field that refers to a node named 'topSeparator' that was
*   DEF'ed earlier in the scene.
* 
* @SEE_ALSO
*    SoField,
*    SoSField,
*    SoMFNode,
*    SoNode
* 
* 
*/
class INVENTOR_API SoSFNode : public SoSField {

  // Use standard field stuff
  SO_SFIELD_HEADER(SoSFNode, SoNode *, SoNode *);

 public:
  /**
   * Gets the value of this field.
   *
   * The getEffectiveNode parameter is only used when the node in the
   * field is a Proto.  In this case, if the parameter is true 
   * then for convenience it returns the first child of the proto 
   * (the node the proto is pretending to be).
   * [OIV-WRAPPER-NOT-WRAP]
   */
  SoNode *getValue(SbBool getEffectiveNode = FALSE); 

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

  // Update a copied field to use the copy of the node if there is one
  virtual void fixCopy(SbBool copyConnections);

  // Override this to also check the stored node
  virtual SbBool referencesCopy() const;

 private:
  // Override this to maintain write-references in node
  virtual void countWriteRefs(SoOutput *out) const;

  // Changes value in field without doing other notification stuff.
  // Keeps track of references and auditors.
  void setVal(SoNode *newValue);

};

#endif /* _SO_SF_NODE_ */

