/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
** Modified by : Nick Thompson (MMM yyyy)
** Modified by : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_SFIELD_
#define  _SO_SFIELD_

#include <Inventor/fields/SoField.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoSField
//
//  Field that always has only one value.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Abstract base class for all single-value fields.
 * 
 * @ingroup fields
 * 
 * @DESCRIPTION
 *   Each class derived from SoSField begins with an SoSF prefix and contains one
 *   value of a particular type. Each has setValue() and getValue()
 *   methods that are used to change or access this value. In addition, some field
 *   classes have extra convenience routines that allow values to be set or retrieved
 *   in other related formats (see below).
 *   
 *   In addition to setValue(), all single-value fields overload the "="
 *   assignment operator to set the field value from the correct datatype or from
 *   another field instance of the same type.
 *   
 *   The value of a single-value field is written to file in a format dependent on the
 *   field type; see the subclass reference pages for details.
 *   
 *   A field that is ignored has a tilde (~) either in place of the value (if the
 *   actual value is the default) or after it (otherwise).
 * 
 * @SEE_ALSO
 *    SoField,
 *    SoMField
 * 
 * 
 */
class INVENTOR_API SoSField : public SoField {
 public:
  // Destructor
#ifndef HIDDEN_FROM_DOC
  virtual ~SoSField();
#endif // HIDDEN_FROM_DOC

  /**
   * Return the type identifier for this field class.
   */
  static SoType getClassTypeId();

 protected:
  // Constructor
  SoSField();
  
 SoINTERNAL public:
  static void initClass();
  static void exitClass();

  static void *createInstance(SoType* dynamicType = NULL);

  // Called by an instance to indicate that a value has changed. If
  // resetDefault is TRUE, this turns off default flag. Initiates
  // notification, if necessary.
  void valueChanged(SbBool resetDefault = TRUE)
    {valueChangedBasic(resetDefault);}

  // Reads value of field
  virtual SbBool readValue(SoInput *in) = 0;
  
  // Writes value of field
  virtual void writeValue(SoOutput *out) const = 0;

private:
  static SoType classTypeId;

};

#endif /* _SO_SFIELD_ */


