/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Julien SALLANNE (Apr 2009)
**=======================================================================*/

#ifndef  _SO_GEOLOCATION_
#define  _SO_GEOLOCATION_

#include <Inventor/fields/SoSFVec3d.h>
#include <Inventor/fields/SoMFString.h>
#include <Inventor/nodes/SoTransformation.h>
#include <Inventor/nodes/SoTransform.h>

/** 
 * @VSGEXT Used to georeference models.
 * 
 * @ingroup GeoNodes
 * 
 * @DESCRIPTION
 *    The SoGeoLocation allows to place a non-georeferenced model at its 
 *   correct location in geospatial coordinates.
 *   
 *    The SoGeoLocation node provides the ability to geo-reference any models.
 *   That is, to take an ordinary model, and to specify its geospatial location.
 *   This node is a grouping node that can be thought of as a Transform node.
 *   However, the GeoLocation node specifies an absolute location, not a relative
 *   one, so content developers should not nest GeoLocation nodes within each other.
 *   The #geoSystem field is used to define the spatial reference frame and is
 *   described in 25.2.3 Specifying a spatial reference frame.
 *   The #geoCoords field should be provided in the format described in
 *   25.2.3 Specifying a spatial reference frame.
 *   The #geoCoords field can be used to dynamically update the geospatial
 *   location of the model.
 * 
 * @FILE_FORMAT_DEFAULT
 *    GeoLocation {
 *    @TABLE_FILE_FORMAT
 *       @TR geoCoords      @TD 0 0 0
 *       @TR geoSystem      @TD ["GD","WE"]
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *      SoGLRenderAction, SoRayPickAction,  SoGetBoundingBoxAction,  SoCallbackAction,
 *      SoGetMatrixAction, SoGetPrimitiveCount  @BR
 * 
 */
class INVENTOR_API SoGeoLocation : public SoTransformation {

  SO_NODE_HEADER(SoGeoLocation);

 public:
  // Fields
  /**
   * Geospatial coordinate used for translation
   */
  SoSFVec3d          geoCoords;

  /**
   * Defines the spatial reference frame. @BR
   * Valid values are:
   * - GC: Earth-fixed Geocentric with respect to the WGS84 ellipsoid.
   * - GD: Geodetic spatial reference frame. @BR
   *   An optional second string may be used to specify the ellipsoid used.
   *   If no ellipsoid is specified, then "WE" is assumed (the WGS84 ellipsoid).
   * - UTM: Universal Transverse Mercator @BR
   *   One further required argument must be supplied for UTM in order to
   *   specify the zone number (1..60). This is given in the form "Zn", where
   *   n is the zone number. An optional argument of "S" may be supplied in 
   *   order to specify that the coordinates are in the southern hemisphere
   *  (otherwise, northern hemisphere will be assumed).
   */
  SoMFString         geoSystem;

  /**
   * Creates a geoLocation node with default settings.
   */
  SoGeoLocation();

 SoEXTENDER public:
  virtual void        doAction(SoAction *action);
  virtual void        callback(SoCallbackAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        getBoundingBox(SoGetBoundingBoxAction *action);
  virtual void        pick(SoPickAction *action);
  virtual void        getMatrix(SoGetMatrixAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoGeoLocation();

 private:
  SbVec3f             m_geoCoords;

  // Apply transformation using forward traversal on this node
  SoRef<SoTransform> m_modelTransform;

};

#endif /* _SO_GEOLOCATION_ */


