/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Julien SALLANNE (Apr 2009)
**=======================================================================*/

#ifndef  _SO_GEORENDER_
#define  _SO_GEORENDER_

#include <Inventor/nodes/SoNode.h>
#include <Inventor/fields/SoSFEnum.h>

/** 
 * @VSGEXT  Defines rendering projection.
 * 
 * @ingroup GeoNodes
 * 
 * @DESCRIPTION
 *    The SoGeoRender node allows applications to choose the render projection.
 * 
 * @FILE_FORMAT_DEFAULT
 *    GeoRender {
 *    @TABLE_FILE_FORMAT
 *       @TR renderProjection     @TD GEOCENTRIC_PROJ
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *      SoGLRenderAction, SoGetBoundingBoxAction, SoCallbackAction  @BR
 * 
 */
class INVENTOR_API SoGeoRender : public SoNode {

  SO_NODE_HEADER(SoGeoRender);

 public:
  // Fields
  /**
   * Geospatial projection.  
   * @useenum{SbProj4Projection::Projection}. Default is GEOCENTRIC_PROJ.
   */
  SoSFEnum            renderProjection;

  /**
   * Constructor.
   */
  SoGeoRender();

 SoEXTENDER public:
  virtual void        doAction(SoAction *action);
  virtual void        callback(SoCallbackAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        getBoundingBox(SoGetBoundingBoxAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoGeoRender();
};

#endif /* _SO_GEORENDER_ */


