/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : ... (MMM yyyy)
** Modified by : ... (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_DOUBLE_TAP_GESTURE_RECOGNIZER_
#define  _SO_DOUBLE_TAP_GESTURE_RECOGNIZER_

#include <Inventor/SbBasic.h>
#include <Inventor/events/SoSubEvent.h>
#include <Inventor/gestures/recognizers/SoGestureRecognizer.h>
#include <Inventor/gestures/events/SoDoubleTapGestureEvent.h>
#include <Inventor/touch/SoTouchManager.h>

/**
 *
 * Double tap gesture recognizer.
 * 
 * @ingroup GesturesRecognizers
 * 
 * @DESCRIPTION
 *   SoDoubleTapGestureRecognizer analyses touch events and recognizes a one finger
 *   double-tap gesture. It returns an SoDoubleTapGestureEvent with this gesture is recognized.
 *   The finger has to stay in a limitation area from the down event to the end one
 *   and must be completed within a maximum elapsed time.
 *   This recognizer only generates an END event.
 *
 *   @B Note@b: 
 *   - In order to get touch events for the gesture recognizer(s) to recognize, the application must 
 *     explicitly register a touch screen device (SoWinTouchScreen, SoQtTouchScreen, etc).
 *   - In order to get gesture events, the application must explicitly register gesture recognizers
 *     with the touch screen device's touch manager (SoTouchManager).
 *
 * @SEE_ALSO
 *    SoGestureRecognizer,
 *    SoLongTapGestureRecognizer,
 *    SoRotateGestureRecognizer,
 *	  SoScaleGestureRecognizer,
 *    SoDoubleTapGestureEvent
 * 
 */
class INVENTOR_API SoDoubleTapGestureRecognizer : public SoGestureRecognizer {
public :

  /**
   * Constructor.
   */
  SoDoubleTapGestureRecognizer();

  /**
   * Destructor.
   */
  virtual ~SoDoubleTapGestureRecognizer();

  /**
   * If a double tap gesture is recognized, returns an SoDoubleTapGestureEvent,
   * else returns null.
   * \if_cpp Returns a pointer to an internal data object. Do not modify or delete this object. \endif
   */
  SoEvent* recognize(SoEvent* touchEvent); 

  /**
   * Gets tap maximum duration (1.0 seconds by default).
   */
  SbTime getMaximumTapDuration() const;

  /**
   * Gets the maximum time that can elapse between the two taps of a double tap.
   * (0.5 seconds by default)
   */
  SbTime getMaximumDurationBetweenTap() const;

  /**
   *  Gets the radius of limitation circle in which the finger has to stay
   *  throughout the gesture (60 pixels by default).
   */
  int getSpatialRestriction(void) const;

  /**
   * Sets tap maximum duration (1.0 seconds by default).
   */
  void setMaximumTapDuration(SbTime time);

  /**
   * Sets the maximum time that can elapse between the two taps of a double tap.
   * (0.5 seconds by default)
   */
  void setMaximumDurationBetweenTap(SbTime t);

  /**
   *  Sets the radius of limitation circle in which the finger has to stay
   *  throughout the gesture. (60 pixels by default)
   */
  void setSpatialRestriction(int c);
  
private:

  SbTime m_maximumDurationBetweenTap;
  SbTime m_maximumTapDuration;
  
  SbVec2f m_firstTapPosition;
  
  int m_spatialRestriction;
  SbTime m_lastTap;
  unsigned long m_id;

  bool m_inProgress;
  bool m_secondTapInProgress;
  bool m_firstTapDone;
  
  SoDoubleTapGestureEvent m_returnedEvent;
};

#endif /* _SO_DOUBLE_TAP_GESTURE_RECOGNIZER_ */

