#pragma once

/*====================================================================================
*** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
***                                                                                ***
***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
***                                                                                ***
***                        RESTRICTED RIGHTS LEGEND                                ***
***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
***                                                                                ***
***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
***                        BORDEAUX, FRANCE                                        ***
***                      ALL RIGHTS RESERVED                                       ***
**==================================================================================*/

#include <Inventor/sys/port.h>
#include <Inventor/SbBase.h>

#include <ostream>

class SbString;

/**
 * @ingroup InventorHelpers
 *
 * List of common graphics capabilities set by Open Inventor.
 *
 * @SEE_ALSO SbGPUCapabilities
 */
class INVENTORBASE_API SbGraphicsCapabilities
{
public:

  // default constructor
  SbGraphicsCapabilities();

  /** Maximum number of tex unit allowed */
  int getMaxTextureUnits() const;

  /** Maximum number of image unit allowed */
  int getMaxImageUnits() const;

  /** Maximum number of texCoord allowed */
  int getMaxTextureCoords() const;

  /** Maximum number of color target allowed */
  int getMaxColorTargets() const;

  /** Maximum number of draw buffers allowed */
  int getMaxDrawBuffers() const;

  /** Maximum number of light allowed */
  int getMaxHardwareLights() const;

  /** Maximum number of clip plane allowed */
  int getMaxClipPlanes() const;

  /** Minimum version of GLSL supported */
  int getMinGLSLVersion() const;

  /** List capabilities in human readable format */
  INVENTORBASE_API friend std::ostream& operator<<(std::ostream& os, const SbGraphicsCapabilities& capabilities);

protected:

  // Maximum number of tex unit allowed
  int m_maxTextureUnits;

  // Maximum number of image unit allowed
  int m_maxImageUnits;

  // Maximum number of texCoord allowed
  int m_maxTextureCoords;

  // Maximum number of color target allowed
  int m_maxColorTargets;

  // Maximum number of draw buffers allowed
  int m_maxDrawBuffers;

  // Maximum number of light allowed
  int m_maxHardwareLights;

  // Maximum number of clip plane allowed
  int m_maxClipPlanes;

  // Minimum version of GLSL supported
  int m_minGLSLVersion;
};
