/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : C. OGNIER (Jun 2003)
**=======================================================================*/


#ifndef _SOSUBIMAGERASTERRW_
#define _SOSUBIMAGERASTERRW_

#include <Inventor/SoType.h> 

///////////////////////////////////////////////////////////
//
//  Internal initialization macros
//
#define SO_IMAGE_RASTER_RW_SOURCE(parent, className, classPrintName) \
\
  SoType className::m_classTypeId; \
\
  SoType \
  className::getClassTypeId() \
  { \
    return m_classTypeId; \
  } \
\
  SoType \
  className::getTypeId() const \
  { \
    return m_classTypeId; \
  } \
\
  void \
  className::initClass() \
  { \
    if ( m_classTypeId.isBad() ) { \
      if (parent::getClassTypeId().isBad() ) \
        parent::initClass(); \
      m_classTypeId = SoType::createType(parent::getClassTypeId(), classPrintName, &className::createInstance); \
    } \
  } \
\
  void \
  className::exitClass() \
  { \
    if ( m_classTypeId != SoType::badType() ) { \
      SoType::removeType(m_classTypeId.getName()); \
      m_classTypeId = SoType::badType(); \
    } \
  } \
  void* \
  className::createInstance(SoType *) \
  { \
    return (void *)(new className); \
  }


#define SO_IMAGE_RASTER_RW_ABSTRACT_SOURCE(className, classPrintName) \
\
  SoType className::m_classTypeId; \
\
  SoType \
  className::getClassTypeId() \
  { \
    return m_classTypeId; \
  } \
\
  void \
  className::initClass() \
  { \
    if ( m_classTypeId.isBad() ) { \
      m_classTypeId = SoType::createType(SoType::badType(), classPrintName); \
    } \
  } \
\
  void \
  className::exitClass() \
  { \
    if ( m_classTypeId != SoType::badType() ) { \
      SoType::removeType(m_classTypeId.getName()); \
      m_classTypeId = SoType::badType(); \
    } \
  } 



#define SO_IMAGE_RASTER_RW_HEADER() \
  public: \
    /** Returns the type identifier for this specific instance. */ \
    virtual SoType getTypeId() const; \
    /** Returns the type identifier for this class.  */ \
    static SoType getClassTypeId(); \
  SoINTERNAL public: \
    static void initClass(); \
    static void exitClass(); \
    static void *createInstance(SoType* dynamicType = 0); \
  \
  private: \
    static SoType   m_classTypeId;

#define SO_IMAGE_RASTER_RW_ABSTRACT_HEADER() \
  public: \
     /** Returns the type identifier for this specific instance. */ \
     virtual SoType getTypeId() const = 0; \
     /** Returns the type identifier for this class.  */ \
     static SoType getClassTypeId(); \
  SoINTERNAL public: \
     static void initClass(); \
     static void exitClass(); \
\
  private: \
    static SoType   m_classTypeId;

#endif

