/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : C. OGNIER (Jun 2003)
**=======================================================================*/


#ifndef _SOTIFFIMAGERW_
#define _SOTIFFIMAGERW_


#include <Inventor/image/SoRasterImageRW.h>
#include <Inventor/threads/SbThreadMutex.h>

SO_PIMPL_PUBLIC_DECLARATION(SoTIFFImageRW);

/**
 *
 * @VSGEXT Class for encoding and decoding a TIFF raster image
 * 
 * @ingroup Image
 *
 * This class is used for encoding and decoding a TIFF raster image.
 *
 * The writeCapability is WRITE_SCANLINES and isMultipleBufferInverted is TRUE.
 *
 * See SoRasterImageRW for more information and code examples.
 * 
 * @SEE_ALSO
 *    SoRasterImageFile, SoRasterImageRW, SbRasterImage
 * 
 * 
 */
class INVENTOR_API SoTIFFImageRW : public SoRasterImageRW {

  SO_IMAGE_RASTER_RW_HEADER()
  SO_PIMPL_PUBLIC_HEADER(SoTIFFImageRW);

public:
   
    /** CompressionMode */
  enum CompressionMode {
    /**
     * No compression
     */
    NO_COMPRESSION,
    /**
     *  Default compression
     */
    PACKBITS_COMPRESSION
  };

  /**
   * Constructor.
   */
  SoTIFFImageRW();

  /**
   * Destructor.
   */ 
  virtual ~SoTIFFImageRW();

  /**
   * Opens the reader/writer in the specified open mode.
   * Returns true if successful.
   */
  virtual SbBool open(SoRasterImageIO* rasterImageIO, OpenMode openMode);

  /**
   * Writes and encodes the given data in the specific format.
   * If you are using the multiple writing mode, then you can specify the 
   * offset (with xPos,yPos) you want to write to.
   */
  virtual SbBool write(SbRasterImage* rasterImage, unsigned int xPos = 0, unsigned int yPos = 0);

  /**
   * Reads, decodes, and fills the @I rasterImage@i parameter.
   * If @I infoOnly@i is TRUE, then the buffer will not be read; the parameter @I rasterImage@i will be
   * set with raster size and raster number of components, the buffer will be NULL.
   */
  virtual SbBool read(SbRasterImage* rasterImage, SbBool infoOnly = FALSE);

  /**
   * @copydoc SoRasterImageRW::readRegion()
   * @warning This implementation read full image and after copy the desired region.
   */
  virtual SbBool readRegion(SbRasterImage* rasterImage, const SbBox2i32& region);

  /**
   * Sets the compression mode to use when encoding the image.
   * Default compression is PACKBITS_COMPRESSION.
   */
  void setCompressionMode(SoTIFFImageRW::CompressionMode compressionMode);


  /**
   * Gets the compression mode used for encoding.
   */
  SoTIFFImageRW::CompressionMode getCompressionMode() const;

SoINTERNAL public:  
  /**
   * @copydoc SoRasterImageRW::read()
   */
  virtual SbBool read(SbRasterImage* rasterImage, size_t imageIndex, SbBool infoOnly = FALSE);

  /**
   * @copydoc SoRasterImageRW::readRegion()
   */
  virtual SbBool readRegion(SbRasterImage* rasterImage, size_t imageIndex, const SbBox2i32& region);

protected:
  virtual void createSuffixList();
  
};

#endif
