/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (Sep 2014)
**=======================================================================*/


#ifndef _SO_CAD_FILE_FORMAT_H_
#define _SO_CAD_FILE_FORMAT_H_

#include <Inventor/SbBasic.h>

// InventorCAD_EXPORTS is defined only when building fei_inventor_io_cad library
#ifdef InventorCAD_EXPORTS
#  define CADFILEFORMAT_API VC_DLL_EXPORT
#else
#  define CADFILEFORMAT_API VC_DLL_IMPORT
#endif

#include <Inventor/io/CAD/SoInventorCADLibName.h>

#ifdef _WIN32
#  ifndef InventorCAD_EXPORTS
#    ifndef OIV_DISABLE_AUTOLINK
#      pragma comment(lib,__INVENTORCADLIB)
#    endif
#  endif
#endif

#include <Inventor/SoModule.h>
SO_MODULE_HEADER(SoCADFileFormat, __INVENTORCADDLL)

/**
 * @VSGEXT Module class to initialize CAD file format support.
 * 
 * @ingroup InventorIOCAD
 * 
 * @DESCRIPTION
 *   This class allows the user to initialize the CAD file format support module.
 *   The module must be initialized before using any other classes of the module.
 *
 *   These formats require redistributing the fei_inventor_io_cad
 *   plugin library with the application (e.g. fei_inventor_io_cad.dll on Windows).
 *
 * @SEE_ALSO
 *   SoCADInputReader, SoCADInputReaderParameters
 * [OIVJAVA-WRAPPER-CLASS BASIC_TYPE{false}]
 */
class CADFILEFORMAT_API SoCADFileFormat {

 public:

  /**
   * Initializes all classes of CADFileFormat modules by registering them
   * in the database. This function needs to be called before any 
   * other class of CADFileFormat may be constructed or accessed. 
   * [OIV-WRAPPER NO_WRAP]
   */
  static void init();

  /** 
   * Frees Open Inventor's internal static memory 
   * allocations. This avoids false positives from memory
   * leak checking software. We recommend calling this method
   * and it should be the last Open Inventor method called by
   * the application.
   * [OIV-WRAPPER NO_WRAP]
   */
  static void finish();

  /**
   * Returns a character string identifying the name of the extension.
   */
  static const char *getProductName();

#if SoDEPRECATED_BEGIN(2023200)
  /**
   * Returns a character string identifying the version of the extension.
   */
  SoDEPRECATED_METHOD(2023.2, "This method should no longer be used. Use SoLicensesInfo::getVersion() method instead.")
  static const char *getVersion();
#endif /** @DEPRECATED_END */

  /**
   * Return true if this plugin has been initialized (init() method called at least once)
   * [OIV-WRAPPER NO_WRAP]
   */
  static bool isInitialized()
  {  return (s_initRefCount>0); }

 private:

  // reference counter on the lib.
  static int s_initRefCount;

};
/*---------------------------------------------------------------------------*/

// Declare plugin entry points for dynamic plugin loading
extern "C" CADFILEFORMAT_API void initPlugin();
extern "C" CADFILEFORMAT_API void exitPlugin();

#endif // _SO_CAD_FILE_FORMAT_H_

