/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Created by : VSG (mar 2012)
**=======================================================================*/

#ifndef  _SO_CAD_INPUT_READER_H_
#define  _SO_CAD_INPUT_READER_H_

#include <Inventor/io/CAD/SoCADFileFormat.h>
#include <Inventor/SoInputReader.h>

class SoDataKitReaderEnabler;

/**
 * @VSGEXT Class for importing a scene graph from a CAD file.
 * 
 * @ingroup InventorIOCAD
 * 
 * @DESCRIPTION
 * This class can import data from a number of CAD file formats to an Open Inventor scenegraph.
 *
 * Note that for each format, if the required license are available reading a file into Open Inventor is just
 * like reading in an Open Inventor format file.
 * Open Inventor will open the file and automatically detect its format and use this class to do the import.
 *
 * List of supported formats:
 *   @TABLE_1B
 *   @TR @B File extensions @b    @TD @B File Format @b 
 *   @TR .catpart, .catproduct    @TD CATIA V5. See @ref CATIAV5_DETAILS.
 *   @TR .3dxml                   @TD CATIA V6. See @ref CATIAV6_DETAILS.
 *   @TR .iges, .igs              @TD IGES reader. See @ref IGES_DETAILS.
 *   @TR .jt                      @TD JT. See @ref JT_DETAILS.
 *   @TR .xmt, .x_t, .x_b         @TD ParaSolid. see @ref PARASOLID_DETAILS.
 *   @TR .par, .asm, .psm, .pwd   @TD SolidEdge. see @ref SOLIDEDGE_DETAILS
 *   @TR .sldprt, .sldasm         @TD SolidWorks. see @ref SOLIDWORKS_DETAILS
 *   @TR .prt                     @TD Unigraphics. see @ref UNIGRAPHICS_DETAILS
 *   @TR .step, .stp, .stp.Z      @TD STEP. see @ref STEP_DETAILS
 *   @TR .dwg                     @TD Autocad Dwg. see @ref DWG_DETAILS.
 *   @TR .asm, .prt, .xar, .xpr   @TD PROECREO. see @ref PROECREO_DETAILS.
 *   @TR .vda                     @TD VDA.
 *   @TABLE_END
 *
 * @B Important Notes:@b @BR
 *
 * Part names will be imported, but since the names are assigned directly to nodes, the Open 
 * Inventor node name limitations will be enforced automatically (see SoBase::setName()).
 * For example " " (blank or space) characters are replaced with "_" (underscore) characters
 * and a leading "#" (hash or pound sign) character will be replaced with "_" (underscore).
 *
 * 
 * @anchor CATIAV5_DETAILS @B CATIA V5 Input details@b:
 *
 *   - Supports release from CatiaV5 R7 to R23 (called V5-6R2013)
 *
 * @anchor CATIAV6_DETAILS @B CATIA V6 Input details@b:
 *
 *   - Supports the Geometry Reading from R2010x to R2013x.
 *
 * @anchor DWG_DETAILS @B DWG Input details@b:
 *
 *   - Supports version from 2.5 up to 2013 
 *   - Converts 3D entities (3D solids) and meshes (3D surfaces)
 *   - Converts wireframe
 *   - Does not convert drawings elements (for example: labels, tables)
 *   - Does not convert kinematics, layer filter, axis system and camera elements
 *   - Type of files read : *.dwg
 * 
 * @anchor IGES_DETAILS @B IGES Input details@b:
 *
 *   - Supports release until 5.3
 *
 * @anchor JT_DETAILS @B JT Input details@b:
 *
 *   - Supports Tesselated Jt 3D files, and B-REP.
 *   - Supports formats up 10.2.
 *
 * @anchor PARASOLID_DETAILS @B PARASOLID Input details@b:
 *
 *   - Supports version: v7 to v26
 *
 * @anchor PROECREO_DETAILS @B ProE/Creo Parametric Input details@b:
 * 
 *   - Supports Pro/E 2000i to Creo Parametric 2.0
 *
 * @anchor SOLIDEDGE_DETAILS @B SolidEdge Input details@b:
 *
 *   - Support version: up to ST6.
 *
 * @anchor SOLIDWORKS_DETAILS @B SolidWorks Input details@b:
 *
 *   - Support version: 1999 to 2014.
 *
 * @anchor STEP_DETAILS @B STEP Input details@b:
 *
 *   - Support STEP protocols : AP203 (Edition 1, Edition 2), AP214 (up to Edition 3), AP242 (Edition 1 pre-DIS).
 *
 * @anchor UNIGRAPHICS_DETAILS @B Unigraphics Input details@b:
 *
 *   - Supports version: v10 to UGNX9
 *
 * @SEE_ALSO
 *    SoInput,
 *    SoInputParameters,
 *    SoCADFileFormat,
 *    SoCADInputReaderParameters
 *
 */
class CADFILEFORMAT_API SoCADInputReader : public SoInputReader
{
  SO_TYPED_CLASS_HEADER();
public:
  /** Constructor. */
  SoCADInputReader();

  /** Destructor. */
  virtual ~SoCADInputReader();

  /** @copydoc SoInputReader::canConvert */
  virtual bool canConvert(SoInput*);

  /** @copydoc SoInputReader::convert */
  virtual SoSeparator* convert(SoInput*);

private:
  SoDataKitReaderEnabler* m_datakitReaderEnabler;
};

#endif // _SO_CAD_INPUT_READER_H_

