/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Created by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SO_NODE_INDEX_H
#define SO_NODE_INDEX_H

#include <Inventor/SbBase.h>

namespace inventor
{
  /** Structure used by SoPath for it child indices. Allows to handle multiple instance and forward traversal */
  SoINTERNAL struct NodeIndex
  {
    // IndexType in [0..instanceNr) to identify a specific instance
    // IndexType := NODE to identify the node itself without referring a specific instance
    // IndexType := ALL_INSTANCE to identify the selection of all the instances (this is a commodity to use just one path instead of potentially many ones)
    enum Type
    {
      INSTANCE_INDEX = 0,
      NODE = -1, 
      ALL_INSTANCE = -2,
      FORWARD_TRAVERSAL = -3
    };

    NodeIndex() : index(-1), instanceIndex(NODE) {}

    NodeIndex(int nodeIndex, int instanceIndex)
      : index(nodeIndex), instanceIndex(instanceIndex)
    {
    }

    NodeIndex(int nodeIndex, Type indexType)
      : index(nodeIndex), type(indexType)
    {
    }

    /** Child index */
    int index;
    union
    {
      /** Is the index simple node, multipleinstance or mark a forward traversal */
      Type type;
      /** Intance index if type is >= INSTANCE_INDEX */
      int instanceIndex;
    };
  };
} 

#endif
