/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2021 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Created by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SB_STRING_LIST_H
#define SB_STRING_LIST_H

#include <Inventor/SbPList.h>
class SbString;

/**
 * Maintains a list of pointers to SbString instances.
 *
 * @ingroup General
 *
 * @DESCRIPTION
 *   This subclass of SbPList holds a list of SbString pointers.
 *
 *   @B Note:@b Because this is a list of pointers, not a list of objects,
 *   the destructor for this class does @I not@i free the memory
 *   associated with the SbString objects.  If your application creates
 *   or takes ownership of an SbStringList, you are responsible for
 *   deleting the SbString objects.
 *
 * @EXAMPLE
 *
 * Conversion QStringList -> SbStringList
 * \code
 *  QStringList qlist;
 *  qlist<<str1<<str2<<[etc.];
 *  SbStringList slist;
 *  for(const QString &str : qlist)
 *    slist.append(&(new SbString)->fromWideChar(qstr.toStdWString().c_str()));
 * \endcode
 *
 * @SEE_ALSO
 *    SbString
 *
 *
 * [OIV-WRAPPER-CUSTOM-CODE]
 */
class INVENTORBASE_API SbStringList : public SbPList
{
 public:

  /**
   * Adds given SbString pointer to end of list.
   */
  void append(SbString *string);

  /**
   * Adds given string to the end of the list.
   * A new SbString instance is created and must be deleted by user.
   */
  void append( const char* );

  /**
   * Returns index of given SbString in list, or -1 if not found (pointer check)
   */
  int find(SbString *string);

  /**
   * Returns index of given SbString in list, or -1 if not found (string check)
   */
  int findString( const SbString &string) const;

  /**
   * Inserts given SbString in list before SbString with given index
   */
  void insert(SbString *string, int addBefore);

  /** @copydoc SbPList::operator[]() */
  SbString*& operator [](int i) const;

  /**
   * This function splits a string according to a separator.
   *
   * @param str The string to split.
   * @param separator The separator which is used to split the string.
   *
   * @return The list of strings.
   */
  static SbStringList split( const SbString& str, const SbString& separator );

};

#endif
