/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : David Mott (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_CALLBACK_LIST_
#define  _SO_CALLBACK_LIST_

#include <Inventor/SbPList.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoCallbackList
//
//////////////////////////////////////////////////////////////////////////////

/**
 * @brief Callback functions that are registered with this class should
 * be cast to this type.
 *
 * @memberof SoCallbackList
 */
typedef void SoCallbackListCB(void *userData, void *callbackData);

/**
 * Manages a list of \if_dotnet delegates \else callbacks \endif and associated data.
 * 
 * @ingroup General
 * 
 * @DESCRIPTION
 *   This class manages a list of \if_dotnet delegates \else callbacks \endif and user data. The user can add
 *   a \if_dotnet delegate \else callback \endif to the list, along with user data. When the \if_dotnet delegate \else callback \endif is
 *   invoked, it is passed this user data, along with \if_dotnet delegate \else callback \endif data specified by the
 *   invoking routine. The type of this \if_dotnet delegate \else callback \endif data is determined by the invoking
 *   routine.
 * 
 * 
 * [OIV-WRAPPER-NO-WRAP]
 */
class INVENTOR_API SoCallbackList {
    
 public:

  /**
   * Constructor.
   */
  SoCallbackList();
  /**
   * Destructor.
   */
  ~SoCallbackList();
  
  /**
   * Adds a function to the list of callback functions.
   * At callback time, f will be called with userData as the first
   * parameter, and callback specific data as the second parameter.
   * e.g. (*f)(userData, callbackData);
   */
  void addCallback(SoCallbackListCB *f, void *userData = NULL);
  /**
   * Removes a function from the list of callback functions.
   */
  void removeCallback(SoCallbackListCB *f, void *userData = NULL);
    
  /**
   * Clears all callback functions from the list.
   */
  void clearCallbacks() { list.truncate(0); }
  /**
   * Returns the number of callback functions in the list.
   */
  int getNumCallbacks() const { return list.getLength(); }

  /**
   * Invokes each callback function in the list, passing each function the user data
   * supplied when they were registered here, and @B callbackData @b, the
   * callback-specific data supplied by the caller.
   */
  void invokeCallbacks(void *callbackData);
  
  /**
  * Set the callbacks enabled state.  Callbacks are enabled by default.
  * If callbacks are disabled, invokeCallbacks has no effect.
  */
  void enable(SbBool enableCallbacks){ m_enable = enableCallbacks;}

 private:
  
   //If set tofalse, callbacks will have no effect
   SbBool m_enable;

  // callbackList holds a list of functions and user data
  SbPList list;

};

#endif  /* _SO_CALLBACK_LIST_ */

