/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/



#ifndef  _SO_COMPACT_PATH_LIST_
#define  _SO_COMPACT_PATH_LIST_

#include <Inventor/misc/SoRefCounter.h>

// forward declaration of implementation class
class SoCompactPathListImpl;
class SoPathList;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoCompactPathList (internal)
//
//  This class represents a list of paths (like an SoPathList) in a
//  more compact form. Since many paths in a path list may share
//  common sub-paths from common head nodes, this class stores them
//  with less redundancy.
//
//  The SoCompactPathList constructor is passed an SoPathList. It is
//  assumed that the SoPathList is not empty and that all paths in the
//  SoPathList have a common head node; an error will occur otherwise.
//  It is also assumed that no two paths are identical, and that if
//  one path goes through node X, then no other path will end at node
//  X.
//
//  While an SoPathList provides random access to any node in any
//  path, an SoCompactPathList provides only sequential access. That
//  is, you can only access the paths in the list in order. Each
//  instance maintains the notion of the "current node" - the node
//  that traversal has last reached - to support this access.
//
//////////////////////////////////////////////////////////////////////////////

SoINTERNAL class INVENTOR_API SoCompactPathList : public SoRefCounter
{

 public:
  // Constructor given path list
  SoCompactPathList(const SoPathList &list);
  ~SoCompactPathList();

  // Resets traversal to the beginning. This allows an instance to
  // be traversed more than once.
  void reset();

  // Returns the indices of the current node that are in paths in
  // the list. The number of indices is returned in "numIndices",
  // and the indices are returned in "indices". numIndices will be 0
  // if the current node has no children in any path.
  void getChildren(int &numIndices, const int *&indices);

  // Traverses the child with given index of the current node. The
  // child becomes the new current node. If the child is on a path
  // in the list, then getChildren() can be called to get the next
  // set of children. Otherwise, it will always return no children.
  // This method returns TRUE if the given childIndex is in one of
  // the paths in the list, and FALSE otherwise.
  //
  // lastFound is an inout parameter that contains the last indices found in the compactPathList
  // for the current separator. When iterating over children of a separator it
  // should be set to 0 on first call then the returned result has to be reused until the last
  // call for the separator.
  SbBool push(int childIndex, int &lastFound);

  // Restores current node to what it was before the most recent push()
  void pop();

 private:
  // implementation class
  SoCompactPathListImpl* m_impl;
};

#endif // _SO_COMPACT_PATH_LIST_

