/*=================================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),        ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                 ***
 ***                                                                            ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS   ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR   ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                       ***
 ***                                                                            ***
 ***                        RESTRICTED RIGHTS LEGEND                            ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS  ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN  ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT  ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN  ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.         ***
 ***                                                                            ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                    ***
 ***                              BORDEAUX, FRANCE                              ***
 ***                            ALL RIGHTS RESERVED                             ***
 =================================================================================*/

#ifndef SO_LICENSE_PROPERTY_H
#define SO_LICENSE_PROPERTY_H

#include <Inventor/misc/SoRefCounter.h>
#include <Inventor/SbPImpl.h>

class CLicensesTools;
namespace inventor {
namespace impl {
class SoLicensesInfoImpl;
}
} // namespace inventor

SO_PIMPL_PUBLIC_DECLARATION(SoLicensedProduct)

SO_PIMPL_BASE_PUBLIC_DECLARATION(SoLicenseProperty)

/**
  * @VSGEXT Class providing information about a licensed product.
 *
 * @ingroup lock
 *
 * @DESCRIPTION
 * This class provides information about a product license,
 * such as the product version or expiration date of the license.
 */
class INVENTORBASE_API SoLicenseProperty : public SoRefCounter
{
  SO_PIMPL_BASE_PUBLIC_HEADER(SoLicenseProperty)

public:
  SoLicenseProperty();
  virtual ~SoLicenseProperty();

  /**
   * Indicates the type of the license (SDK or RunTime).
   */
  enum SbLicenseType
  {
    /** indicates the product can be used as an SDK */
    SDK,
    /** indicates the product is used in RunTime mode only */
    RT
  };

  /**
   * Returns the name of the product for this license.
   */
  const SbString& getProductName() const;

  /**
   * Returns the version of the product for this license.
   */
  const SbString& getProductVersion() const;

  /**
   * Returns the expire date of the product for this license.
   */
  const SbString& getExpirationDate() const;

  /**
   * Return the maximum number of licenses for the product.
   */
  const SbString& getNumUsers() const;

  /**
   * Returns the checksum of this license.
   *
   * @B Limitation: @b This function returns a non-empty string only if a master password is used.
   */
  const SbString& getCheckSum() const;

  /**
   * @B Limitation: @b This function returns a non-empty string only if a master password is used.
   */
  const SbString& getInfo() const;

  /**
   * @B Limitation: @b This function returns a non-empty string only if a master password is used.
   */
  const SbString& getHostID() const;

  /**
   * Gets the product type (RunTime or SDK).
   */
  SbLicenseType getLicenseType() const;

  /**
   * Returns true if the product is expired.
   */
  bool isExpired() const;

  /**
   * Gets number of days before expiration for the given product version.
   * Returns : 0 if license has expired or never expires
   *          >0 if license has not expired
   *          -1 if license is invalid
   */
  int getDaysToExpire() const;

  /**
   * Returns true if the license is a master password.
   */
  bool isMasterPassword() const;

#ifndef HIDDEN_FROM_DOC
  // Only CLicensesTools and SoLicensedProductImpl are allowed to modify SbLicenseProperty impl members.
  friend class CLicensesTools;
  friend class inventor::impl::SoLicensedProductImpl;
  friend class inventor::impl::SoLicensesInfoImpl;
#endif /* HIDDEN_FROM_DOC */
};

#endif /* SO_LICENSE_PROPERTY_H */
