/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul Isaacs (MMM yyyy)
** Modified by : Thad Beier (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2023 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_NODEKIT_PARTS
#define  _SO_NODEKIT_PARTS

#include <Inventor/nodekits/SoNodekitCatalog.h>

class SoNodeKitListPart;
class SoBaseKit;
class SoNode;
class SoFullPath;
class SoSFNode;

////////////////////////////////////////////////////////////////////
//    Class: SoNodekitParts
////////////////////////////////////////////////////////////////////
/** [OIV-WRAPPER-CLASS NO_WRAP] */
SoEXTENDER class INVENTOR_API SoNodekitParts {

 SoEXTENDER public:
  // Instances of SoNodekitParts are created only by subclasses of SoBaseKit.

  // Constructor -- requires a catalog to build
  SoNodekitParts( SoBaseKit *rootOfKit );

  // Destructor
  ~SoNodekitParts();

//! @cond Doxygen_Suppress
  friend class SoBaseKit;
//! @endcond

 private:
  const SoNodekitCatalog *catalog;   // the catalog to use in building
  // parts
  int                     numEntries;   // must be made equal to numEntries
  // in the catalog
  SoBaseKit               *rootPointer; // Pointer to the part 'this'
  SoSFNode                **fieldList;  // each 'part' is actually just
  // a node, stored in a field

  SbBool makePart( const int partNum );
  SbBool replacePart( const int partNum, SoNode *newPartNode );
  void   unregisterDescendants( const int partNum );

  SoNode *getPartFromThisCatalog( const int partNum, SbBool makeIfNeeded,
                                  SbBool leafCheck, SbBool publicCheck, 
                                  SbBool &existedBefore );
  SoFullPath *createPathToPartFromThisCatalog( const int partNum, 
                                               SbBool makeIfNeeded, SbBool leafCheck, 
                                               SbBool publicCheck,  SbBool &existedBefore );
  SbBool setPartFromThisCatalog( const int partNum, 
                                 SoNode *newPartNode,
                                 SbBool anyPart );

  SoNode *getSingleNamePart( const SbName &nameOfPart, SbBool makeIfNeeded,
                             SbBool leafCheck, SbBool publicCheck, 
                             SbBool &existedBefore );
  SoFullPath *getSingleNamePathToPart( const SbName &nameOfPart, 
                                       SbBool makeIfNeeded, SbBool leafCheck, 
                                       SbBool publicCheck, SbBool &existedBefore );
  SbBool setSingleNamePart( const SbName &nameOfPart, SoNode *newPartNode,
                            SbBool anyPart );

  // returns the part requested. If 'leafCheck' then it will only return 
  // leaves. If 'publicCheck', then it will only return public parts.
  // Otherwise it will also return interior parts.
  // Interior parts are ordinarily not obtainable through public methods.
  SoNode *getAnyPart( const SbName &nameOfPart, SbBool makeIfNeeded, 
                      SbBool leafCheck, SbBool publicCheck );
  SoNode *getAnyPart( const SbName &nameOfPart, SbBool makeIfNeeded, 
                      SbBool leafCheck, SbBool publicCheck, 
                      SbBool &existedBefore);
  SoFullPath *createPathToAnyPart( const SbName &nameOfPart, 
                                   SbBool makeIfNeeded, SbBool leafCheck, SbBool publicCheck );
  SoFullPath *createPathToAnyPart( const SbName &nameOfPart, 
                                   SbBool makeIfNeeded, SbBool leafCheck, 
                                   SbBool publicCheck,  SbBool &existedBefore );
  SbBool setAnyPart(  const SbName &nameOfPart, SoNode *newPartNode, 
                      SbBool anyPart);

  // parse a string like 'nameOfList[elementNum]' into two parts...
  // Destructive to parseString, so give it a copy if you care.
  // Replaces the '[' with an end-of-string and reads elementNum 
  // into the integer given
  SbBool parseListItem( char* parseString, int &index );

  // help to delete unneeded parts...
  SbBool partIsNonLeafAndMayBeDeleted( int partNum );

  // error check functions...
  SbBool partFoundCheck( int partNum );
  SbBool partIsLeafCheck( int partNum );
  SbBool partIsPublicCheck( int partNum );
  SbBool verifyPartExistence( int partNum );

  // builds a path from the entry 'this' down to the entry given
  // by 'nameOfPart'. Assumes that 'theNode' matches 'nameOfPart'
  SoFullPath *createPathDownTo( const SbName &nameOfPart, SoNode *theNode );

  // appends pathB after pathA and returns result.
  // result is NULL if either path is NULL or if pathA->tail != pathB->head
  SoFullPath *addPaths( const SoFullPath *pathA, 
                        const SoFullPath *pathB ) const;
};

#endif  /* _SO_NODEKIT_PARTS */


