/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/
#ifndef _SO_BEVEL_PROPERTY
#define _SO_BEVEL_PROPERTY

#include <Inventor/nodes/SoNode.h>
#include <Inventor/fields/SoSFFloat.h>
#include <Inventor/fields/SoSFBitMask.h>
#include <Inventor/fields/SoSFBool.h>

class SoBevelAction;

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoBevelProperty
//
//  Node used to set the bevel properties for all subsequent shapes.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * @VSGEXT Node to define beveling properties.
 * 
 * @ingroup PropertyNodes
 * 
 * @DESCRIPTION
 *   This node defines the current beveling properties (used by SoBevelAction) for
 *   all subsequent shapes. 
 *   
 *   You can use it to specify a beveling radius (absolute or relative) and an angle
 *   between adjacent faces (like a crease angle) that determines if the edge between
 *   those faces will be beveled.
 * 
 * @FILE_FORMAT_DEFAULT
 *    BevelProperty {
 *    @TABLE_FILE_FORMAT
 *       @TR angle              @TD 0.5
 *       @TR radius             @TD 0.05
 *       @TR absoluteRadius     @TD FALSE
 *       @TR testsBeforeBevel   @TD DUPLICATE_TEST | ORDERING_TEST
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    Sets: SoBevelPropertyElement
 * 
 * @SEE_ALSO
 *    SoBevelAction,
 *    SoEdgeFlag,
 *    SoVertexFlag
 * 
 * 
 */
class INVENTOR_API SoBevelProperty : public SoNode
{
  SO_NODE_HEADER(SoBevelProperty);

 public:
   /** Test */
  enum Test
  {
    /**
     *  Concatenate coplanar faces 
     */
    COPLANAR_TEST   = 0x01,
    /**
     *  Remove duplicate faces 
     */
    DUPLICATE_TEST  = 0x02,
    /**
     *  Reorder facet normals 
     */
    ORDERING_TEST   = 0x04,
    /**
     *  All tests 
     */
    ALL_TESTS               = 0x07
  };
  /**
   * Indicates the angle (in radians, between 0 and pi) between two adjacent face
   * normals @I above @i which the edge will be beveled. (If the edge has been
   * unmarked by the current SoEdgeFlag it will not be beveled, regardless of the
   * value of #angle). 
   * 
   */
  SoSFFloat     angle;
  /**
   * This defines the bevel radius (the size of the rounded edge or corner). This
   * value will be interpreted as absolute or relative depending on the
   * #absoluteRadius flag (below).
   * 
   */
  SoSFFloat     radius;
  /**
   * If TRUE, the value of #radius will be taken as the bevel radius.
   * Otherwise, the radius is relative to the shape: the #radius value is a
   * fraction between 0.0 and 1.0. The bevel radius will be @B max * radius @b,
   * where @B max @b is the length of the longest edge of the current shape to be
   * beveled.
   * 
   */
  SoSFBool      absoluteRadius;

  /**
   * Which tests should be performed in order to "clean up" the shape before it is
   * beveled.
   * 
   */
  SoSFBitMask   testsBeforeBevel;

  /**
   * Constructor.
   */
  SoBevelProperty();

 SoEXTENDER public:
  virtual void  doAction(SoAction *action);
  virtual void  bevel(SoBevelAction *action);
  virtual void  callback(SoCallbackAction *action);

 SoINTERNAL public:
  static void initClass();
  static void exitClass();
  static const float    DEFAULT_RADIUS;
  static const SbBool   DEFAULT_ABSOLUTE_RADIUS;
  static const float    DEFAULT_ANGLE;
  static const int              DEFAULT_TESTS;

 protected:
  virtual ~SoBevelProperty();

private:

  /** Flag for the type of the output shapes. */
  SoDEPRECATED_FIELD(10000,"No more used.")
  SoSFBool      vrmlOutput;
};

#endif

