/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/
#ifndef  _SO_CLIP_PLANE_
#define  _SO_CLIP_PLANE_

#include <Inventor/fields/SoSFBool.h>
#include <Inventor/fields/SoSFPlane.h>
#include <Inventor/nodes/SoNode.h>

/**
* Clipping plane node.
* 
* @ingroup TransformNodes
* 
* @DESCRIPTION
*   This node clips all subsequent shapes in the scene graph to the half-space
*   defined by the #plane field. The half-space is the side of the plane in
*   the direction of the plane normal. For example, if the plane is positioned at
*   the origin and the normal is pointing down the positive X axis, everything in
*   the negative X space will be clipped away.
*   
*   Any number of clipping planes may be active simultaneously, although the graphics
*   library may place a limit on this number during rendering.
*
*   For an interactive version of this node, see class SoClipPlaneManip.
*   Also see the clip plane dragger example in the Resources section of
*   the Open Inventor Forum: http://forum.openinventor.com/showthread.php?t=733 
*   (registration is required to view this section of the forum).
* 
* @FILE_FORMAT_DEFAULT
*    ClipPlane {
*    @TABLE_FILE_FORMAT
*       @TR plane   @TD 1 0 0 0
*       @TR on      @TD TRUE
*    @TABLE_END
*    }
* 
* @ACTION_BEHAVIOR
*    SoGLRenderAction,  SoCallbackAction,  SoRayPickAction @BR
*        Adds the plane to the current list of clipping planes in the state.
*        Sets: SoClipPlaneElement
* 
* @SEE_ALSO
*    SoCamera,
*    SoShapeHints,
*    SoClipPlaneManip
* 
*/
class INVENTOR_API SoClipPlane : public SoNode {

  SO_NODE_HEADER(SoClipPlane);

public:
  /** Plane defining half-space. */
  SoSFPlane           plane;

  /** Whether clipping plane is active. */
  SoSFBool            on;

  /** Creates a clip plane node with default settings. */
  SoClipPlane();

  SoEXTENDER public:
  /** @copydoc SoNode::doAction */
  virtual void doAction(SoAction *action);

  /** @copydoc SoNode::GLRender */
  virtual void GLRender(SoGLRenderAction *action);

  /** @copydoc SoNode::callback */
  virtual void callback(SoCallbackAction *action);

  /** @copydoc SoNode::pick */
  virtual void pick(SoPickAction *action);

  SoINTERNAL public:

  /** @copydoc SoNode::initClass */
  static void initClass();
  /** @copydoc SoNode::exitClass */
  static void exitClass();

protected:
  /** default Destructor */
  virtual ~SoClipPlane();
};

#endif /* _SO_CLIP_PLANE_ */


