/*==============================================================================
***   THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),    ***
***             AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                ***
***                                                                          ***
*** REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS  ***
*** SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR  ***
*** WRITTEN AUTHORIZATION OF FEI S.A.S.                                      ***
***                                                                          ***
***                       RESTRICTED RIGHTS LEGEND                           ***
*** USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS ***
*** WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN ***
*** SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT ***
*** CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN ***
*** TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.        ***
***                                                                          ***
***                  COPYRIGHT (C) 1996-2022 BY FEI S.A.S,                   ***
***                           MERIGNAC, FRANCE                               ***
***                         ALL RIGHTS RESERVED                              ***
==============================================================================*/

#pragma once

#include <Inventor/nodes/SoShaderObject.h>
#include <Inventor/fields/SoSFVec3i32.h>

/**
 * @VSGEXT Node that defines a compute shader.
 *
 * @ingroup ShaderNodes
 *
 * @DESCRIPTION
 *   This node defines a compute shader, a shader stage used entirely for computing
 *   arbitrary information.
 *
 *   To store the result of the computation, an SoComputeShader may use
 *   SoShaderParameterImage or SoShaderParameterBufferObject with
 *   SoShaderParameterBufferObject::SHADER_STORAGE_BUFFER buffer type.
 *
 *   To fetch data, an SoComputeShader may use the above-mentioned parameter
 *   types, or regular texture access.
 *
 *   See SoShaderProgram for general information about using shaders and shader parameters.
 *
 *   See parent class SoShaderObject for details about using the inherited fields.
 *
 *   See SoComputeShaderScheduler for information about compute shader invocation.
 *
 *   Notes & Limitations:
 *   - Compute shaders cannot coexist with other shader stages in the same shader
 *     program. Otherwise, an error will be generated and the shader won't
 *     compile (for example, you cannot insert an SoFragmentShader along with an
 *     SoComputeShader into the field SoShaderProgram#shaderObject).
 *   - An SoShaderProgram containing compute shaders cannot be applied on SoShape nodes.
 *     If such a shader program is present on state when a shape is traversed by a
 *     rendering action, errors might be raised and the shape will not be rendered.
 *     To avoid this case, those SoShaderProgram should be isolated in their own SoSeparator,
 *     along with the SoComputeShaderScheduler nodes.
 *
 * @FILE_FORMAT_DEFAULT
 *    ComputeShader {
 *      @TABLE_FILE_FORMAT
 *        @TR sourceProgram    @TD ""
 *        @TR sourceType       @TD FILENAME
 *        @TR isActive         @TD TRUE
 *        @TR parameter        @TD NULL
 *      @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *    SoVertexShader,
 *    SoFragmentShader,
 *    SoGeometryShader,
 *    SoShaderObject,
 *    SoShaderProgram,
 *    SoTessellationControlShader,
 *    SoTessellationEvaluationShader,
 *    SoUniformShaderParameter,
 *    SoShaderParameterBufferObject,
 *    SoShaderParameterImage
 *
 *
 * @NODE_SINCE_OIV 10.12
 */
class INVENTOR_API SoComputeShader : public SoShaderObject
{
  SO_NODE_HEADER(SoComputeShader);

public:
  SoComputeShader();

  /**
   * Indicates if compute shaders in the specified language are supported by
   * your graphics board.
   * When using a debug build of Open Inventor, warning messages such as "no context available"
   * may be generated. You can ignore them or see SoGLExtension for an example of using SoGLContext to avoid them.
   */
  static SbBool isSupported(SoShaderObject::SourceType sourceType, SoState* state = nullptr);

  /** Returns the shader type */
  virtual ShaderType getShaderType() const
  {
    return COMPUTE_SHADER;
  }

SoINTERNAL public:
  static void initClass();
  static void exitClass();

protected:
  virtual ~SoComputeShader();
};
