/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Chris Marrin (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_FONTSTYLE_
#define  _SO_FONTSTYLE_

#include <Inventor/fields/SoSFBitMask.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/nodes/SoFont.h>
#include <Inventor/actions/SoCallbackAction.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoFontStyle
//
//////////////////////////////////////////////////////////////////////////////

/**
 * @VSGEXT Defines font family and style for text.
 * 
 * @ingroup PropertyNodes
 * 
 * @DESCRIPTION
 *   This node defines the current font family and style for all subsequent text
 *   shapes in the scene graph.
 *
 *   @I Note: @i The "name" field inherited from SoFont is ignored by
 *   SoFontStyle. This node maps font family and style to a specific
 *   predefined font, according to the OS in use. Use the #getFontName() method
 *   to get the actual font name that will be used.
 *
 *   On Windows, the font families are mapped as follows:
 *   
 *      @TABLE_0B
 *         @TR SERIF       @TD Times New Roman
 *         @TR SANS        @TD Arial
 *         @TR TYPEWRITER  @TD Courier New
 *      @TABLE_END 
 * 
 * @FILE_FORMAT_DEFAULT
 *    FontStyle {
 *    @TABLE_FILE_FORMAT
 *       @TR name         @TD "defaultFont"
 *       @TR size         @TD 10
 *       @TR family       @TD SERIF
 *       @TR style        @TD NONE
 *       @TR renderStyle  @TD POLYGON
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoGetBoundingBoxAction,  SoRayPickAction @BR
 *        Sets the font family and style in the current traversal state.
 *        Sets: SoFontNameElement, SoFontSizeElement, 
 * 
 * @SEE_ALSO
 *    SoAsciiText,
 *    SoFont,
 *    SoText2,
 *    SoText3
 * 
 * 
 */
class INVENTOR_API SoFontStyle : public SoFont {

  SO_NODE_HEADER(SoFontStyle);

 public:
  /**
   * Creates a font style node with default settings.
   */
  SoFontStyle();

  /** Font style family */
  enum Family {
    /**
     *  Use Serif style (such as Times-Roman) 
     */
    SERIF,
    /**
     *  Use Sans Serif style (such as Helvetica) 
     */
    SANS,
    /**
     *  Use fixed pitch style (such as Courier) 
     */
    TYPEWRITER
  };

  enum Style {
    /**
     *  No modification to Family 
     */
    NONE = 0,
    /**
     *  Embolden Family 
     */
    BOLD = 0x1,
    /**
     *  Italicize or slant Family 
     */
    ITALIC = 0x2
  };

  // Fields
  /**
   * Specifies the family of font to use (which determines the font name according to table above).
   * @useenum{Family}.  Default is SERIF.
   */
  SoSFEnum    family;
  /**
   * Specifies style of the chosen font.
   * @useenum{Style}. Default is NONE.
   */
  SoSFBitMask style;
    
  /**
   * Returns the font name used by this node based on the settings of family and
   * style.
   */
  SbString            getFontName();

 SoEXTENDER public:
  virtual void        doAction(SoAction *action);
  virtual void        callback(SoCallbackAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        getBoundingBox(SoGetBoundingBoxAction *action);
  virtual void        pick(SoPickAction *action);
  virtual void        getPrimitiveCount(SoGetPrimitiveCountAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoFontStyle();
    
 private:
  static const char *fontList[][4];
};

#endif /* _SO_FONTSTYLE_ */

