/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

                                                             /* include files */
#ifndef _SO_FRAGMENT_SHADER_H_
#define _SO_FRAGMENT_SHADER_H_

#include <Inventor/nodes/SoShaderObject.h>


/**
 *
 * @VSGEXT Node that defines a fragment shader.
 * 
 * @ingroup ShaderNodes
 * 
 * @DESCRIPTION
 *   This node defines a fragment shader. 
 *
 *   See SoShaderProgram for general information about using shaders and shader parameters.
 *
 *   See parent class SoShaderObject for details about using the inherited fields.
 *
 * @B Notes:@b 
 * - Shaders in the scene graph. @BR
 *   Shader object nodes cannot be inserted directly in a scene graph. @BR
 *   They must be added to the @I shaderObject @i field of an SoShaderProgram node. 
 *
 * - Predefined GLSL variables. @BR
 *   Open Inventor uses a compatibility profile context for rendering.  So legacy GLSL
 *   predefined variables, for example gl_FragColor, can be used in fragment shaders.
 *   However, if you use the GLSL "#version" directive in a shader, you should
 *   append the keyword "compatibility", for example: "#version 150 compatibility".
 *
 * - Transparency. @BR
 *   To maintain compatibility with Open Inventor's high quality transparency algorithms
 *   like SORTED_PIXEL, fragment shaders should not output a color by setting
 *   gl_FragColor (or equivalent parameter) directly.
 *   Use the GLSL method @I OivDepthPeelingOutputColor()@i instead. @BR @BR
 *   Fragment shaders can access the depthPeeling API using Open Inventor's built-in "include"
 *   mechanism as shown below. (Note: In the "oiv_include" statement there must not be any
 *   white space in the string "//!oiv_include".  The space character shown below is required
 *   by a limitation of our documentation tools.)
 *   \par
 *   \code
 *   // Fragment shader GLSL code
 *
 *   // !oiv_include <Inventor/oivDepthPeeling_frag.h> 
 *
 *   void main()
 *   {
 *       if (OivDepthPeel( gl_FragCoord.xyz )) {
 *
 *           // Compute and set fragment color
 *           vec4 color = . . .
 *
 *           OivDepthPeelingOutputColor( color );
 *       }
 *   }
 *   \endcode
 *
 * - Transparency. @BR
 *   If a fragment shader makes geometry transparent (sets alpha values < 1), the
 *   application should set the #SoShaderProgram::generateTransparency field to true.
 *   This ensures that Open Inventor knows to apply the correct handling for the
 *   current transparency mode.
 *
 * - Shadows. @BR
 *   To integrate with Open Inventor's shadow casting algorithm, fragment shaders
 *   should call the GLSL methods OivComputeShadow() and OivGenerateShadowMap().
 *   Please see SoShadowGroup for example code.
 *   
 *
 * @FILE_FORMAT_DEFAULT
 *    FragmentShader {
 *      @TABLE_FILE_FORMAT
 *        @TR sourceProgram    @TD ""
 *        @TR sourceType       @TD FILENAME
 *        @TR isActive         @TD TRUE
 *        @TR parameter        @TD NULL
 *      @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *    SoGeometryShader, 
 *    SoShaderObject, 
 *    SoShaderProgram,
 *    SoTessellationControlShader, 
 *    SoTessellationEvaluationShader, 
 *    SoUniformShaderParameter,
 *    SoVertexShader
 *
 * 
 */
class INVENTOR_API SoFragmentShader : public SoShaderObject
{
  SO_NODE_HEADER(SoFragmentShader);

public:
  /**
   * Constructor.
   */
  SoFragmentShader();

  /**
   * Indicates if fragment shaders in the specified language are supported by 
   * your graphics board.
   * When using a debug build of Open Inventor, some "no context available"
   * warning messages may be generated. You can ignore them or see
   * SoGLExtension for an example of using SoGLContext to avoid them.
   */
  static SbBool isSupported(SoShaderObject::SourceType sourceType, SoState* state=NULL) ;

  /**
  *  Returns the maximum number of texture image units.
  */
  static unsigned int getMaxTextureImageUnit() ;

  /** Returns the shader type */
  virtual ShaderType getShaderType() const
  { return FRAGMENT_SHADER; }

SoINTERNAL public:

  /** register class in database */
  static void initClass();

  /** unregister class in database */
  static void exitClass();

  /** return true if GL_ARB_fragment_program_shadow extensions is supported */
  static bool isFragmentShadowSupported(SoState* state);

  /** return true if GL_ARB_draw_buffers extensions is supported */
  static bool isDrawBuffersSupported(SoState* state);

protected:
  /** Destructor */
  virtual ~SoFragmentShader();
};

#endif /* _SO_FRAGMENT_SHADER_ */


