/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2020 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

                                                             /* include files */
#ifndef _SO_GEOMETRY_SHADER_H_
#define _SO_GEOMETRY_SHADER_H_

#include <Inventor/nodes/SoShaderObject.h>

/**
 * @VSGEXT Node that defines a geometry shader.
 * 
 * @ingroup PropertyNodes
 * 
 * @DESCRIPTION
 *   This node defines a geometry shader. 
 *
 *   See SoShaderProgram for general information about using shaders and shader parameters.
 *
 *   See parent class SoShaderObject for details about using the inherited fields.
 *
 * @B Notes:@b 
 *   - Shader object nodes cannot be inserted directly in a scene graph. \n
 *     They must be added to the @I shaderObject @i field of an SoShaderProgram node. 
 *
 *   - Since Open Inventor 10.0, when writing geometry shaders, the input and output
 *     primitive types must be specified in the shader code.
 *     See https://developer.openinventor.com/index.php/general-documentation/how-to-write-shaders-with-oiv-10/#geomshader for
 *     more information.
 *
 * @B Limitations:@b
 *   - Transparency and fast editing are compatible with shader modified geometry, but most
 *     actions use the vertices of the basic shape (the vertices stored in the scene graph).
 *     This includes, for example, SoGetBoundingBoxAction, SoGetPrimitiveCountAction and SoRayPickAction.
 *   - The input primitive type must match the primitive type used with the rendering command that renders
 *     with this shader program. Valid inputs are points, lines and triangles so shapes like SoCube, SoIndexedFaceSet
 *     defines with quads or polygons, SoQuadMesh are not compatible with SoGeometryShader.
 *
 * @FILE_FORMAT_DEFAULT
 *    GeometryShader {
 *      @TABLE_FILE_FORMAT
 *        @TR sourceProgram    @TD ""
 *        @TR sourceType       @TD FILENAME
 *        @TR isActive         @TD TRUE
 *        @TR parameter        @TD NULL
 *      @TABLE_END
 *    }
 *
 * @SEE_ALSO
 *    SoFragmentShader, 
 *    SoVertexShader, 
 *    SoShaderObject, 
 *    SoShaderProgram,
 *    SoTessellationControlShader, 
 *    SoTessellationEvaluationShader
 *    SoUniformShaderParameter,
 *
 * 
 */
class INVENTOR_API SoGeometryShader : public SoShaderObject 
{
  SO_NODE_HEADER(SoGeometryShader);

public:
  /**
   * Constructor.
   */
  SoGeometryShader();

  /**
   * Indicates if geometry shaders in the specified language are supported by 
   * your graphics board.
   * When using a debug build of Open Inventor, some "no context available"
   * warning messages may be generated. You can ignore them or see
   * SoGLExtension for an example of using SoGLContext to avoid them.
   */
  static SbBool isSupported(SoShaderObject::SourceType sourceType, SoState* state=NULL) ;

  /** Returns the shader type */
  virtual ShaderType getShaderType() const
  { return GEOMETRY_SHADER; }

SoINTERNAL public:

  /** register class in database */
  static void initClass();

  /** unregister class in database */
  static void exitClass();

  virtual void notify( SoNotList* list );

  /** Parses the shader program to retrieve the input layout. */
  const SbString& getInputLayout();

  /** Translates geometry input layout from SoShaderProgram::GeometryInputType enum value to glsl layout type */
  static const SbString& getInputLayoutFromType( int inputType );

protected:
  /** Destructor */
  virtual ~SoGeometryShader();

private:
  /** The current input layout of this geometry shader object */
  SbString m_inputLayout;

  /** Cache for stored input layout value */
  bool m_inputLayoutDirty;
};

#endif


