/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David Beilloin (Mar 2011)
** Modified by : VSG (MMM YYYY)
**=======================================================================*/

#ifndef  _SO_INDEXED_TRIANGLE_SET_
#define  _SO_INDEXED_TRIANGLE_SET_

#include <Inventor/nodes/SoIndexedShape.h>
#include <Inventor/SbPImpl.h>

class SoNormalBundle;
class SoShapeStyleElement;
class SoVolumeIndexedTriangleSet;

SO_PIMPL_PUBLIC_DECLARATION(SoIndexedTriangleSet)

//@TOBEWRAPPED
/**
* Indexed triangle shape node.
* 
* @ingroup ShapeNodes
* 
* @DESCRIPTION
*   This node represents a 3D shape defined by a set of triangles.
*   This shape node constructs triangles from the vertices located at the coordinates 
*   specified in the #vertexProperty field (from SoVertexShape), or the current 
*   inherited state. For optimal performance, the #vertexProperty field is recommended.
*
*   SoIndexedTriangleSet uses the indices in the coordIndex field (from SoIndexedShape)
*   to specify the vertices of the triangles. Each triangle is specified by three
*   indices.  Unlike SoIndexedFaceSet (for example) no -1 values are needed or allowed.
*   The number of triangles is the number of indices divided by three.
*
*   The vertices of the faces are transformed by the current transformation matrix.
*   The faces are drawn with the current light model and drawing style.
*   
*   Treatment of the current material and normal binding is as follows: The PER_PART
*   and PER_FACE bindings specify a material or normal for each triangle. PER_VERTEX
*   specifies a material or normal for each vertex. The corresponding _INDEXED
*   bindings are the same, but use the #materialIndex or #normalIndex
*   indices (see SoIndexedShape). The default material binding is OVERALL. The
*   default normal binding is PER_VERTEX_INDEXED.
*   
*   If any normals (or materials) are specified, Open Inventor assumes you provided
*   the correct number of them, as indicated by the binding. You will see unexpected
*   results if you specify fewer normals (or materials) than the shape requires. If
*   no normals are specified, they will be generated automatically.
*   
*   Textures are applied as described for the SoIndexedShape class.
*
*   Limitations:
*   - Currently does not use OpenGL VBOs (vertex buffer objects) for rendering (and
*     performance may be lower) when both texture coordinates are specified.
*
*   @NODE_SINCE_OIV 8.6
*
* @FILE_FORMAT_DEFAULT
*    IndexedFaceSet {
*    @TABLE_FILE_FORMAT
*       @TR vertexProperty      @TD NULL
*       @TR coordIndex          @TD 0
*       @TR materialIndex       @TD -1
*       @TR normalIndex         @TD -1
*       @TR textureCoordIndex   @TD -1
*    @TABLE_END
*    }
* 
* @ACTION_BEHAVIOR
*    SoGLRenderAction @BR
*        Draws triangles based on the current coordinates, normals, materials, drawing
*        style, and so on.
* 
*    SoRayPickAction @BR
*        Picks triangles based on the current coordinates and transformation. Details about
*        the intersection are returned in an SoFaceDetail.
* 
*    SoGetBoundingBoxAction @BR
*        Computes the bounding box that encloses all vertices of the face set with the
*        current transformation applied to them. Sets the center to the average of the
*        coordinates of all vertices.
* 
*    SoCallbackAction @BR
*        If any triangle callbacks are registered with the action, they will be invoked
*        for each successive triangle generated from each triangle in the set.
* 
* 
* @SEE_ALSO
*    SoCoordinate3,
*    SoDrawStyle,
*    SoFaceDetail,
*    SoTriangleSet,
*    SoFullSceneAntialiasing,
*    SoVertexProperty,
*    SoShapeHints
* 
* 
*/
class INVENTOR_API SoIndexedTriangleSet : public SoIndexedShape
{
  SO_NODE_HEADER(SoIndexedTriangleSet);
  SO_PIMPL_PUBLIC_HEADER(SoIndexedTriangleSet)

public:
  // Inherits fields

  /**
   * Creates an indexed triangle set node with default settings.
   */
  SoIndexedTriangleSet();

SoEXTENDER public:
  // Implements actions

  /** @copydoc SoIndexedShape::GLRender */
  virtual void GLRender( SoGLRenderAction* action );

  /** @copydoc SoIndexedShape::generateDefaultNormals */
  virtual void generateDefaultNormals( SoState* state,
                                       const SbVec3f* coords,
                                       int numCoords,
                                       SoNormalBundle* nb,
                                       SbBool storeRef = FALSE );

  /** Disable tangents generation for triangle shapes */
  virtual void shouldGenerateTangents( SoGLRenderAction* /*action*/, const SoShapeStyleElement* /*shapeStyle*/ ) {}

  /** @copydoc SoIndexedShape::getPrimitiveCount */
  virtual void getPrimitiveCount( SoGetPrimitiveCountAction* action );
                                                  
SoINTERNAL public:

  /** @copydoc SoIndexedShape::initClass */
  static void initClass();

  /** @copydoc SoIndexedShape::exitClass */
  static void exitClass();
  
  // set numTris/Quads/Faces to -1 when notified
  virtual void notify( SoNotList* list );

  // Compute the number of vertices. This is just an approximation,
  //so using 5 verts per unknown polygon is close enough. 
  virtual int getNumPrim( SoState* state = NULL );

protected:

  // This enum is used to indicate the current material or normal binding
  enum Binding {
    OVERALL, PER_FACE, PER_FACE_INDEXED, PER_VERTEX,
    PER_VERTEX_INDEXED
  };

  virtual SbBool shouldGenerateTexture3DCoordinates(){return TRUE;}

  virtual void callSetupIndices( SoState* state, const SoShapeStyleElement* shapeStyle, uint32_t useTexCoordsAnyway );

  //Wether to check or not 3d tex coords
  virtual SbBool checkTex3Coords(){return TRUE;}

  int getNumPrim( SoState* state, int& _numTris );

  virtual void countPrim( SoState* state = NULL );

  // Generates triangles representing faces
  virtual void generatePrimitives( SoAction* action);

  // render function
  virtual void doRendering(SoGLRenderAction* action, const SoShapeStyleElement* shapeStyle);

  // Overrides standard method to create an SoFaceDetail instance
  virtual SoDetail *createTriangleDetail( SoRayPickAction* action,
                                          const SoPrimitiveVertex* v1,
                                          const SoPrimitiveVertex* v2,
                                          const SoPrimitiveVertex* v3,
                                          SoPickedPoint* pp);

  // destructor
  virtual ~SoIndexedTriangleSet();

private:

  friend class SoVolumeIndexedTriangleSetDl;
  friend class SoVolumeIndexedTriangleSet;
};

#endif /* _SO_INDEXED_TRIANGLE_SET_ */


