/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Gavin Bell (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2019 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_INDEXED_TRIANGLE_STRIP_SET_
#define  _SO_INDEXED_TRIANGLE_STRIP_SET_

#include <Inventor/nodes/SoIndexedShape.h>
#include <Inventor/SbPImpl.h>

class SoCoordinateElement;
class SoNormalBundle;

SO_PIMPL_PUBLIC_DECLARATION(SoIndexedTriangleStripSet)

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoIndexedTriangleStripSet
//
//  Indexed set of triangles strips.  Strips are separated by the
//  special index SO_END_STRIP_INDEX (-1).  The N indices in the strip
//  define N-2 triangles, which are formed by indexing into the
//  current coordinates. Depending on the current material and normal
//  binding values, the materials and normals for the triangles or
//  vertices may be accessed in order or indexed. If they are indexed,
//  the materialIndex and normalIndex fields are used.
//
//////////////////////////////////////////////////////////////////////////////

// This coordinate index indicates that the current triangle ends and the
// next triangle begins
#define SO_END_STRIP_INDEX      (-1)

/**
 * Indexed triangle strip set shape node.
 *
 * @ingroup ShapeNodes
 *
 * @DESCRIPTION
 *   This shape node constructs triangle strips out of vertices located at the
 *   coordinates specified in the #vertexProperty field (from SoVertexShape),
 *   or the current inherited coordinates. For optimal performance, the
 *   #vertexProperty field is recommended.
 *
 *   SoIndexedTriangleStripSet uses the indices in the #coordIndex field (from
 *   SoIndexedShape) to specify the vertices of the triangle strips. An index of
 *   SO_END_STRIP_INDEX (-1) indicates that the current strip has ended and the next
 *   one begins.
 *
 *   The vertices of the faces are transformed by the current transformation matrix.
 *   The faces are drawn with the current light model and drawing style.
 *
 *   Treatment of the current material and normal binding is as follows: PER_PART
 *   specifies a material or normal per strip. PER_FACE binding specifies a material
 *   or normal for each triangle. PER_VERTEX specifies a material or normal for each
 *   vertex. The corresponding _INDEXED bindings are the same, but use the
 *   #materialIndex or #normalIndex indices (see SoIndexedShape). The
 *   default material binding is OVERALL. The default normal binding is
 *   PER_VERTEX_INDEXED
 *
 *   If any normals (or materials) are specified, Open Inventor assumes you provide
 *   the correct number of them, as indicated by the binding. You will see unexpected
 *   results if you specify fewer normals (or materials) than the shape requires. If
 *   no normals are specified, they will be generated automatically.
 *
 *   To render triangles that are not in strips, see the SoIndexedTriangleSet node.
 *
 *   Limitations:
 *   - Due to limitations of the OpenGL VBO (vertex buffer object) rendering model, it is not possible
 *     to use VBO rendering (and performance may be lower) if either the normal binding or the material
 *     binding is set to either PER_PART(_INDEXED) or PER_FACE(_INDEXED).
 *
 * @FILE_FORMAT_DEFAULT
 *    IndexedTriangleStripSet {
 *    @TABLE_FILE_FORMAT
 *       @TR vertexProperty      @TD NULL
 *       @TR coordIndex          @TD -1
 *       @TR materialIndex       @TD -1
 *       @TR normalIndex         @TD -1
 *       @TR textureCoordIndex   @TD -1
 *    @TABLE_END
 *    }
 *
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Draws a strip set based on the current coordinates, normals, materials, drawing
 *        style, and so on.
 *
 *    SoRayPickAction @BR
 *        Picks on the strip set based on the current coordinates and transformation.
 *        Details about the intersection are returned in an SoFaceDetail.
 *
 *    SoGetBoundingBoxAction @BR
 *        Computes the bounding box that encloses all vertices of the strip set with the
 *        current transformation applied to them. Sets the center to the average of the
 *        coordinates of all vertices.
 *
 *    SoCallbackAction @BR
 *        If any triangle callbacks are registered with the action, they will be invoked
 *        for each successive triangle forming the strips of the set.
 *
 *
 * @SEE_ALSO
 *    SoCoordinate3,
 *    SoDrawStyle,
 *    SoFaceDetail,
 *    SoFullSceneAntialiasing,
 *    SoIndexedFaceSet,
 *    SoIndexedTriangleSet,
 *    SoTriangleStripSet,
 *    SoVertexProperty
 *
 *
 */
class INVENTOR_API SoIndexedTriangleStripSet : public SoIndexedShape
{
  SO_NODE_HEADER(SoIndexedTriangleStripSet);
  SO_PIMPL_PUBLIC_HEADER(SoIndexedTriangleStripSet)

public:
  /**
   * Returns number of strips.
   */
  int getNumStrips( SoState* state = NULL );

  /**
   * Returns number of triangles.
   */
  int getNumTriangles( SoState* state = NULL );

  // Constructor
  /**
   * Creates an indexed triangle strip set node with default settings.
   */
  SoIndexedTriangleStripSet();

SoEXTENDER public:
  // Implements actions
  virtual void GLRender( SoGLRenderAction* action );

  virtual void getPrimitiveCount( SoGetPrimitiveCountAction* action );

 // Generates default normals using the given normal bundle.
  virtual void generateDefaultNormals( SoState* state,
                                       const SbVec3f* coords,
                                       int numCoords,
                                       SoNormalBundle* nb,
                                       SbBool storeRef = FALSE );

  /** Disable tangents generation for triangle shapes */
  virtual void shouldGenerateTangents( SoGLRenderAction* /*action*/, const SoShapeStyleElement* /*shapeStyle*/ ) {}

SoINTERNAL public:
  static void initClass();
  static void exitClass();

  // return num vertices for test
  virtual int getNumVert( SoState* state = NULL );

  // return num strips for test
  virtual int getNumPrim( SoState* state = NULL );

protected:
  // This enum is used to indicate the current material or normal binding
  enum Binding {
    OVERALL,
    PER_STRIP,
    PER_STRIP_INDEXED,
    PER_TRIANGLE,
    PER_TRIANGLE_INDEXED,
    PER_VERTEX,
    PER_VERTEX_INDEXED
  };

  // Generates triangles representing strips
  virtual void generatePrimitives( SoAction* action );

  // count primitives
  virtual void countPrim( SoState* state = NULL );

  virtual void callSetupIndices( SoState* state, const SoShapeStyleElement* shapeStyle, uint32_t useTexCoordsAnyway );

  // render function
  void doRendering( SoGLRenderAction* action, const SoShapeStyleElement* shapeStyle );

  // Overrides standard method to create an SoFaceDetail instance
  virtual SoDetail* createTriangleDetail( SoRayPickAction* action,
                                          const SoPrimitiveVertex* v1,
                                          const SoPrimitiveVertex* v2,
                                          const SoPrimitiveVertex* v3,
                                          SoPickedPoint* pp );

  ~SoIndexedTriangleStripSet();

private:

  static const int AUTO_CACHE_ITSS_MIN_WITHOUT_VP;
  static const int AUTO_CACHE_ITSS_MAX;
};

#endif /* _SO_INDEXED_TRIANGLE_STRIP_SET_ */
