/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author(s) : VSG (oct 2011)
**=======================================================================*/


#ifndef  _SO_MULTI_PATH_SWITCH_
#define  _SO_MULTI_PATH_SWITCH_

#include <Inventor/nodes/SoGroup.h>
#include <Inventor/fields/SoMFPath.h>

/** 
 * Group node that traverses only when traversed along a given path.
 * 
 * @ingroup GroupNodes
 * 
 * @DESCRIPTION
 *   SoMultiPathSwitch is a group node that traverses its children only if the current
 *   traversal path matches one of the SoPath specified in the #paths field. 
 *
 *   This can be used, for example, to affect only specific instances of a subgraph. 
 *   The #paths field contains a list of paths up to (but not including) the SoMultiPathsSwitch. 
 *   The paths need not go all the way back to the root; if they do not, then only the number of
 *   ancestors that are in the path are compared to see if the children should be
 *   traversed. 
 *
 *   An empty #paths (the default) means that no children are traversed.
 *
 *   Effectively this is an extended version of SoPathSwitch.
 *
 *   @B Note@b: This node disables the bounding box cache for all SoSeparator nodes above
 *   it in the scene graph. This may reduce performance when moving the camera and the 
 *   viewer's auto clip plane adjustment is enabled (the default). (It does not affect render caching.)
 * 
 * @FILE_FORMAT_DEFAULT
 *    MultiPathSwitch {
 *    @TABLE_FILE_FORMAT
 *       @TR paths   @TD NULL
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGetBoundingBoxAction @BR
 *        Traverses the children if the paths match. Disables bounding box caches.
 *
 *    SoGLRenderAction,  SoCallbackAction,  SoGetBoundingBoxAction,  SoRayPickAction,  SoHandleEventAction @BR
 *        Traverses the children if the paths match.
 * 
 * 
 * @SEE_ALSO
 *    SoMultiSwitch,
 *    SoPath,
 *    SoPathSwitch,
 *    SoSwitch
 * 
 */
class INVENTOR_API SoMultiPathSwitch : public SoGroup
{

  SO_NODE_HEADER(SoMultiPathSwitch);

 public:
  /**
   * The list of paths that can match the current traversal path.
   * Default is empty (no children will be traversed).
   */
  SoMFPath paths;

  /**
   * Create a multi-path switch node with default settings.
   */
  SoMultiPathSwitch();

  /**
   * Constructor that takes approximate number of children.
   */
  SoMultiPathSwitch(int nChildren);

 SoEXTENDER public:
  // Implement actions
  virtual void doAction(SoAction *action);
  virtual void GLRender(SoGLRenderAction *action);
  virtual void pick(SoPickAction *action);
  virtual void getBoundingBox(SoGetBoundingBoxAction *action);
  virtual void handleEvent(SoHandleEventAction *action);
  virtual void getMatrix(SoGetMatrixAction *action);
  virtual void search(SoSearchAction *action);
  virtual void getPrimitiveCount(SoGetPrimitiveCountAction *action);

 SoINTERNAL public:
  static void initClass();
  static void exitClass();

 protected:
  virtual ~SoMultiPathSwitch();

 private:

  // Checks for match of path with current path
  SbBool matchesPath(const SoPath *switchPath, const SoPath *currentPath) const;
};

#endif // _SO_MULTI_PATH_SWITCH_


