/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Paul S. Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_NORMAL_BINDING_
#define  _SO_NORMAL_BINDING_

#include <Inventor/SbVertexAttributeBinding.h>
#include <Inventor/fields/SoSFEnum.h>
#include <Inventor/nodes/SoNode.h>
#include <Inventor/elements/SoNormalBindingElement.h> // SoNormalBindingElement::NONE, SoNormalBindingElement::DEFAULT

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoNormalBinding
//
//  Normal binding node. This indicates how multiple surface normals are
//  to be distributed over an object.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * Node that specifies how multiple surface normals are bound to shapes.
 * 
 * @ingroup PropertyNodes
 * 
 * @DESCRIPTION
 *   This node specifies how the current normals are bound to shapes that follow in
 *   the scene graph. Each shape node may interpret bindings differently.
 *   
 *   The bindings for faces and vertices are meaningful only for shapes that are made
 *   from faces and vertices. Similarly, the indexed bindings are only used by the
 *   shapes that allow indexing. For bindings that require multiple normals, be sure
 *   to have at least as many normals defined as are necessary; otherwise, errors
 *   will occur.
 * 
 * @FILE_FORMAT_DEFAULT
 *    NormalBinding {
 *    @TABLE_FILE_FORMAT
 *       @TR value   @TD PER_VERTEX_INDEXED
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoRayPickAction @BR
 *        Sets the current normal binding type. Sets: SoNormalBindingElement
 * 
 * 
 * @SEE_ALSO
 *    SoMaterialBinding,
 *    SoNormal,
 *    SoTextureCoordinateBinding,
 *    SoVertexShape,
 *    SoVertexProperty
 * 
 * 
 */
class INVENTOR_API SoNormalBinding : public SoNode {

  SO_NODE_HEADER(SoNormalBinding);

 public:

   /** Binding */
  enum Binding {
    /**
     *  Whole object has same normal 
     */
    OVERALL           = SbVertexAttributeBinding::OVERALL,
    /**
     *  One normal for each part of object 
     */
    PER_PART          = SbVertexAttributeBinding::PER_PART,
    /**
     *  One normal for each part, indexed 
     */
    PER_PART_INDEXED  = SbVertexAttributeBinding::PER_PART_INDEXED,
    /**
     *  One normal for each face of object 
     */
    PER_FACE          = SbVertexAttributeBinding::PER_FACE,
    /**
     *  One normal for each face, indexed 
     */
    PER_FACE_INDEXED  = SbVertexAttributeBinding::PER_FACE_INDEXED,
    /**
     *  One normal for each vertex of object 
     */
    PER_VERTEX        = SbVertexAttributeBinding::PER_VERTEX,
    /**
     *  One normal for each vertex, indexed 
     */
    PER_VERTEX_INDEXED= SbVertexAttributeBinding::PER_VERTEX_INDEXED

    // Obsolete bindings:
    ,
    DEFAULT           = SoNormalBindingElement::DEFAULT,
    NONE              = SoNormalBindingElement::NONE
  };

  // Fields
  /**
   * Specifies how to bind normals to shapes.
   * @useenum{Binding}. Default is PER_VERTEX_INDEXED.
   */
  SoSFEnum            value;

  /**
   * Creates a normal binding node with default settings.
   */
  SoNormalBinding();

 SoEXTENDER public:
  virtual void        doAction(SoAction *action);
  virtual void        GLRender(SoGLRenderAction *action);
  virtual void        callback(SoCallbackAction *action);
  virtual void        pick(SoPickAction *action);
  virtual void        getPrimitiveCount(SoGetPrimitiveCountAction *action);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

 protected:
  virtual ~SoNormalBinding();

  // Reads stuff into instance. Upgrades old bindings.
  virtual SbBool      readInstance(SoInput *in, unsigned short flags);
};

#endif /* _SO_NORMAL_BINDING_ */

