/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Dave Immel (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_NURBS_CURVE_
#define  _SO_NURBS_CURVE_

#include <Inventor/fields/SoMFFloat.h>
#include <Inventor/fields/SoSFInt32.h>
#include <Inventor/nodes/SoShape.h>

SO_PIMPL_PUBLIC_DECLARATION(SoNurbsCurve)

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoNurbsCurve
//
//  NURBS curve. The curve consists of a knot vector and order for
//  the U parametric directions.  The control points for the curve
//  are obtained from the current coordinates.
//
//////////////////////////////////////////////////////////////////////////////

/**
 * NURBS curve shape node.
 * 
 * @ingroup ShapeNodes
 * 
 * @DESCRIPTION
 *   This class represents a NURBS curve, based on the knot vector and the control
 *   points that you specify. The #knotVector field specifies a floating-point
 *   array of values; the values are the coordinates of the knot points in the curve,
 *   and you must enter them in non-decreasing order. The curve will use the first
 *   #numControlPoints values in the current coordinates as control points.
 *   
 *   If you specify @B n @b knots, you can specify up to @B n-8 @b control points.
 *   The number of knots minus the number of control points is known as the order of
 *   the curve. A NURBS curve can have an order of up to 8.
 *   
 *   The control points of the curve are transformed by the current transformation
 *   matrix. The curve is drawn with the current lighting model and drawing style
 *   (drawing style FILLED is treated as LINES). The coordinates, normals, and
 *   texture coordinates of a NURBS curve are generated, so you cannot bind explicit
 *   normals or texture coordinates to a NURBS curve.
 *   
 *   The approximation of the curve by line segments is affected by the current
 *   complexity value.
 *
 *   Shape Antialiasing type is SoShape::LINES.
 * 
 * @FILE_FORMAT_DEFAULT
 *    NurbsCurve {
 *    @TABLE_FILE_FORMAT
 *       @TR numControlPoints   @TD 0
 *       @TR knotVector         @TD 0
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction @BR
 *        Draws the curve based on the current coordinates, material, and so on.
 * 
 *    SoRayPickAction @BR
 *        Picks the curve based on the current coordinates and transformation.
 * 
 *    SoGetBoundingBoxAction @BR
 *        Computes the bounding box that encloses all control points of the curve with
 *        the current transformation applied to them. Sets the center to the average of
 *        the control points.
 * 
 *    SoCallbackAction @BR
 *        If any line segment callbacks are registered with the action, they will be
 *        invoked for each successive segment approximating the curve.
 * 
 * 
 * @SEE_ALSO
 *    SoFullSceneAntialiasing,
 *    SoIndexedNurbsCurve,
 *    SoNurbsSurface
 * 
 * 
 */
class INVENTOR_API SoNurbsCurve : public SoShape {
  
  SO_NODE_HEADER(SoNurbsCurve);
  SO_PIMPL_PUBLIC_HEADER(SoNurbsCurve)
  
 public:
  /**
   * Number of control points.
   */
  SoSFInt32 numControlPoints;

  /**
   * The knot vector.
   */
  SoMFFloat knotVector;

  /**
   * Creates a NURBS curve node with default settings.
   */
  SoNurbsCurve();

 SoEXTENDER public:
  virtual void GLRender(SoGLRenderAction *action);
  virtual void rayPick(SoRayPickAction *action);
  virtual void getPrimitiveCount(SoGetPrimitiveCountAction *action);
  
  // Redefine this to tell open caches that they contain lines
  virtual void getBoundingBox(SoGetBoundingBoxAction *action);

  // Computes bounding box of curve
  virtual void computeBBox(SoAction *action, SbBox3f &box,
                           SbVec3f &center);
  
 SoINTERNAL public:
  static void initClass();
  static void exitClass();
  
 protected:
  // Generates triangles representing a sphere
  virtual void generatePrimitives(SoAction *action);
  
  ~SoNurbsCurve();

};

#endif /* _SO_NURBS_CURVE_ */

