/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : Thad Beier (MMM yyyy)
** Modified by : Dave Immel (MMM yyyy)
** Modified by : Paul Strauss (MMM yyyy)
**=======================================================================*/
/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2014 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Modified by : VSG (MMM YYYY)
**=======================================================================*/


#ifndef  _SO_NURBS_PROFILE_
#define  _SO_NURBS_PROFILE_

#include <Inventor/fields/SoMFFloat.h>
#include <Inventor/fields/SoSFNode.h>
#include <Inventor/nodes/SoProfile.h>

//////////////////////////////////////////////////////////////////////////////
//
//  Class: SoNurbsProfile
//
//
//////////////////////////////////////////////////////////////////////////////
/**
 * NURBS profile curve.
 * 
 * @ingroup PropertyNodes
 * 
 * @DESCRIPTION
 *   This node specifies a NURBS curve that is used as a profile.
 *   
 *   When a NURBS shape is rendered, its NURBS profile is constructed using the NURBS
 *   profile information from this node and the current profile coordinates. (Note:
 *   Here "current" means at the time the NURBS shape is traversed, not when the
 *   SoNurbsProfile is traversed.)
 *   
 *   The curve is defined in the same way as a standard SoNurbsCurve, except that the
 *   control points are constructed from the current set of profile coordinates,
 *   using the @B index @b field. 
 *
 *   When two profiles 
 *   share the same boundary, the corresponding NURBS surfaces will be joined along these
 *   profiles, producing crack-free tessellation. Two profiles share
 *   the same boundary when their #boundary fields contain the same SoNurbsBoundary node.
 *   To be rendered crack free, the surfaces must be part of the same SoNurbsGroup.
 *
 *   Note: Trimmed NURBS are correctly displayed only if an outer boundary is defined
 *   (must have counterclockwise orientation).
 * 
 * @FILE_FORMAT_DEFAULT
 *    NurbsProfile {
 *    @TABLE_FILE_FORMAT
 *       @TR index        @TD 0
 *       @TR linkage      @TD START_FIRST
 *       @TR knotVector   @TD 0
 *       @TR boundary     @TD 0
 *    @TABLE_END
 *    }
 * 
 * @ACTION_BEHAVIOR
 *    SoGLRenderAction,  SoCallbackAction,  SoRayPickAction @BR
 *        Adds a profile to the current traversal state.
 * 
 * 
 * @SEE_ALSO
 *    SoLinearProfile,
 *    SoNurbsCurve,
 *    SoProfileCoordinate2,
 *    SoProfileCoordinate3,
 *    SoNurbsGroup,
 *    SoNurbsBoundary
 * 
 * 
 */
class INVENTOR_API SoNurbsProfile : public SoProfile{

  SO_NODE_HEADER(SoNurbsProfile);

 public:
  /**
   * The knot vector for the NURBS curve. It must be a list of non-decreasing
   * floating point values.
   * 
   */
  SoMFFloat           knotVector;

  /**
   * Associate the profile with the specified boundary using an SoNurbsBoundary node. 
   * All profiles which are associated 
   * with the same boundary are joined together.
   *
   * @FIELD_SINCE_OIV 6.0
   */
  SoSFNode           boundary;

  /**
   * Creates a NURBS profile curve node with default settings.
   */
  SoNurbsProfile();

 SoEXTENDER public:
  // Returns a profile as a trim curve. floatsPerVec will be either
  // 2 or 3 depending on whether the curve is non-rational or
  // rational.
  virtual void        getTrimCurve(SoState *state, int32_t &numPoints,
                                   float *&points, int &floatsPerVec,
                                   int32_t &numKnots, float *&knotVector);

  // Returns vertices approximating the profile
  virtual void        getVertices(SoState *state, int32_t &nVertices,
                                  SbVec2f *&vertices);

 SoINTERNAL public:
  static void         initClass();
  static void         exitClass();

  int getNurbsBoundaryID() { return m_boundaryId; }
  void setNurbsBoundaryID(int id) { m_boundaryId = id; }

 protected:
  virtual ~SoNurbsProfile();

 private:
  int m_boundaryId;
};

#endif /* _SO_NURBS_PROFILE_ */

